/*
 * Decompiled with CFR 0.152.
 */
package jogl2.examples.tutorial.dodatno;

import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.FPSAnimator;

public class Tabla
implements GLEventListener {
    private FPSAnimator animator;
    private GLWindow prozor;
    private static String naslov = "Tabla";
    private int sirinaProzora = 600;
    private int visinaProzora = 500;
    private static final int FPS = 60;
    private static final int BROJ_POLJA = 4;

    public Tabla() {
        GLProfile glp = GLProfile.getDefault();
        GLCapabilities caps = new GLCapabilities(glp);
        caps.setAlphaBits(8);
        caps.setDepthBits(24);
        caps.setDoubleBuffered(true);
        this.prozor = GLWindow.create(caps);
        this.animator = new FPSAnimator(this.prozor, 60, true);
        this.prozor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDestroyNotify(WindowEvent arg0) {
                new Thread(){

                    @Override
                    public void run() {
                        Tabla.this.animator.stop();
                        System.exit(0);
                    }
                }.start();
            }
        });
        this.prozor.addGLEventListener(this);
        this.prozor.setSize(this.sirinaProzora, this.visinaProzora);
        this.prozor.setTitle(naslov);
        this.prozor.setVisible(true);
        this.animator.start();
    }

    @Override
    public void init(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
        gl.glShadeModel(7425);
        gl.glPolygonMode(1028, 6914);
        gl.glEnable(2929);
    }

    @Override
    public void dispose(GLAutoDrawable drawable) {
    }

    @Override
    public void display(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glClear(16640);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glTranslatef(0.0f, 0.0f, -15.0f);
        gl.glRotatef(20.0f, 1.0f, 0.0f, 0.0f);
        gl.glRotatef(50.0f, 0.0f, 1.0f, 0.0f);
        this.crtajTablu(drawable, 1.0f, 0.5f, 0.9f, 0.7f);
        gl.glFlush();
    }

    @Override
    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glViewport(0, 0, width, height);
        this.sirinaProzora = width;
        this.visinaProzora = height;
        this.postaviProjekciju(drawable);
    }

    private void postaviProjekciju(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(-15.0, 15.0, -15.0, 15.0, 0.0, 50.0);
        gl.glMatrixMode(5888);
    }

    private void crtajTablu(GLAutoDrawable drawable, float belaPolja, float crnaPolja, float beleFigure, float crneFigure) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glPushMatrix();
        gl.glTranslatef(-10.0f, 0.0f, -10.0f);
        this.crtajPodlogu(drawable, belaPolja, crnaPolja);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                if ((i + j) % 2 == 0) {
                    gl.glPushMatrix();
                    gl.glTranslatef((float)(5 * j) + 2.5f, 0.0f, (float)(5 * i) + 2.5f);
                    this.crtajZeton(drawable, beleFigure);
                    gl.glPopMatrix();
                }
                if ((3 - i + j) % 2 != 1) continue;
                gl.glPushMatrix();
                gl.glTranslatef((float)(5 * j) + 2.5f, 0.0f, (float)(5 * (3 - i)) + 2.5f);
                this.crtajZeton(drawable, crneFigure);
                gl.glPopMatrix();
            }
        }
        gl.glPopMatrix();
    }

    private void crtajPodlogu(GLAutoDrawable drawable, float belaPolja, float crnaPolja) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glPushMatrix();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                gl.glPushMatrix();
                gl.glTranslatef(5 * j, 0.0f, 5 * i);
                if ((i + j) % 2 == 1) {
                    gl.glColor3f(belaPolja, belaPolja, belaPolja);
                } else {
                    gl.glColor3f(crnaPolja, crnaPolja, crnaPolja);
                }
                gl.glBegin(7);
                gl.glVertex3f(0.0f, 0.0f, 0.0f);
                gl.glVertex3f(5.0f, 0.0f, 0.0f);
                gl.glVertex3f(5.0f, 0.0f, 5.0f);
                gl.glVertex3f(0.0f, 0.0f, 5.0f);
                gl.glEnd();
                gl.glPopMatrix();
            }
        }
        gl.glLineWidth(2.0f);
        gl.glBegin(3);
        gl.glColor3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(20.0f, 0.0f, 0.0f);
        gl.glVertex3f(20.0f, 0.0f, 20.0f);
        gl.glVertex3f(0.0f, 0.0f, 20.0f);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glEnd();
        gl.glPopMatrix();
    }

    private void crtajZeton(GLAutoDrawable drawable, float intenzitet) {
        int ugao;
        GL2 gl = drawable.getGL().getGL2();
        gl.glColor3f(intenzitet, intenzitet, intenzitet);
        gl.glBegin(6);
        gl.glVertex3f(0.0f, 0.5f, 0.0f);
        for (ugao = 0; ugao <= 360; ugao += 20) {
            gl.glVertex3f((float)(2.0 * Math.cos(Math.toRadians(ugao))), 0.5f, (float)(2.0 * Math.sin(Math.toRadians(ugao))));
        }
        gl.glEnd();
        gl.glColor3f(intenzitet * 0.8f, intenzitet * 0.8f, intenzitet * 0.8f);
        gl.glBegin(8);
        for (ugao = 0; ugao <= 360; ugao += 20) {
            gl.glVertex3f((float)(2.0 * Math.cos(Math.toRadians(ugao))), 0.0f, (float)(2.0 * Math.sin(Math.toRadians(ugao))));
            gl.glVertex3f((float)(2.0 * Math.cos(Math.toRadians(ugao))), 0.5f, (float)(2.0 * Math.sin(Math.toRadians(ugao))));
        }
        gl.glEnd();
    }

    public static void main(String[] args) {
        new Tabla();
    }
}

