/*
 * Decompiled with CFR 0.152.
 */
package jogl2.examples.tutorial;

import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.awt.TextRenderer;
import de.matthiasmann.twl.utils.PNGDecoder;
import java.awt.Font;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class Stapanje_5
implements GLEventListener,
KeyListener {
    private final GLWindow prozor;
    private static final String NASLOV = "(5) Stapanje";
    private int sirinaProzora = 1000;
    private int visinaProzora = 600;
    float proporcijaProzora;
    private static final int FPS = 60;
    private final FPSAnimator animator;
    private TextRenderer txtRenderer;
    private GLU glu;
    private boolean promenaProjekcije = false;
    private int tekuciUgaoVidnogPolja = 60;
    private static final String[] BLEND_FUNC_NAMES = new String[]{"ZERO", "ONE", "SRC_COLOR", "ONE_MINUS_SRC_COLOR", "SRC_ALPHA", "ONE_MINUS_SRC_ALPHA", "DST_ALPHA", "ONE_MINUS_DST_ALPHA"};
    private static final int[] BLEND_FUNC = new int[]{0, 1, 768, 769, 770, 771, 772, 773};
    private static final String[] BLEND_STATE = new String[]{"OFF", "ON"};
    private int mod = 1;
    private int blendState = 0;
    private final int[] textureID = new int[1];
    private int srcFunc = 0;
    private int dstFunc = 0;
    private ByteBuffer pixelData;
    private int imageWidth;
    private int imageHeight;

    public Stapanje_5() {
        GLProfile glp = GLProfile.getDefault();
        GLCapabilities caps = new GLCapabilities(glp);
        caps.setAlphaBits(0);
        caps.setDepthBits(24);
        caps.setDoubleBuffered(true);
        this.prozor = GLWindow.create(caps);
        this.animator = new FPSAnimator(this.prozor, 60, true);
        this.prozor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDestroyNotify(WindowEvent arg0) {
                System.exit(0);
            }
        });
        this.prozor.addGLEventListener(this);
        this.prozor.addKeyListener(this);
        this.prozor.setSize(this.sirinaProzora, this.visinaProzora);
        this.prozor.setTitle(NASLOV);
        this.prozor.setVisible(true);
        this.animator.start();
    }

    public void postaviProjekciju(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.glu.gluPerspective(this.tekuciUgaoVidnogPolja, this.proporcijaProzora, 1.0f, 40.0f);
        gl.glMatrixMode(5888);
    }

    @Override
    public void init(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        gl.glShadeModel(7425);
        gl.glPolygonMode(1032, 6914);
        gl.glEnable(2929);
        this.txtRenderer = new TextRenderer(new Font("SansSerif", 1, 30));
        this.glu = GLU.createGLU(gl);
        this.LoadGLTexture(drawable, "src/slike/sah.png", this.textureID);
    }

    @Override
    public void dispose(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glDeleteTextures(1, IntBuffer.wrap(this.textureID));
    }

    @Override
    public void display(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glClear(16640);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        if (this.mod == 1 || this.mod == 2) {
            gl.glActiveTexture(33984);
            gl.glDisable(3553);
            gl.glDisable(3042);
            gl.glTranslatef(0.0f, 0.0f, -6.0f);
            gl.glBegin(7);
            gl.glColor4f(0.7f, 0.7f, 0.7f, 0.5f);
            gl.glVertex3f(-2.5f, -2.5f, 0.0f);
            gl.glVertex3f(2.5f, -2.5f, 0.0f);
            gl.glVertex3f(2.5f, 2.5f, 0.0f);
            gl.glVertex3f(-2.5f, 2.5f, 0.0f);
            gl.glEnd();
            gl.glEnable(3042);
            gl.glBlendFunc(BLEND_FUNC[this.srcFunc], BLEND_FUNC[this.dstFunc]);
            gl.glTranslatef(0.0f, 0.0f, 0.5f);
            gl.glBegin(7);
            gl.glColor4f(1.0f, 0.0f, 0.0f, 0.0f);
            gl.glVertex3f(-3.0f, 0.5f, 0.0f);
            gl.glColor4f(1.0f, 0.0f, 0.0f, 0.33f);
            gl.glVertex3f(-0.5f, 0.5f, 0.0f);
            gl.glColor4f(1.0f, 0.0f, 0.0f, 0.67f);
            gl.glVertex3f(-0.5f, 3.0f, 0.0f);
            gl.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
            gl.glVertex3f(-3.0f, 3.0f, 0.0f);
            gl.glColor4f(0.0f, 1.0f, 0.0f, 0.0f);
            gl.glVertex3f(0.5f, 0.5f, 0.0f);
            gl.glColor4f(0.0f, 1.0f, 0.0f, 0.33f);
            gl.glVertex3f(3.0f, 0.5f, 0.0f);
            gl.glColor4f(0.0f, 1.0f, 0.0f, 0.67f);
            gl.glVertex3f(3.0f, 3.0f, 0.0f);
            gl.glColor4f(0.0f, 1.0f, 0.0f, 1.0f);
            gl.glVertex3f(0.5f, 3.0f, 0.0f);
            gl.glColor4f(0.0f, 0.0f, 1.0f, 0.0f);
            gl.glVertex3f(-1.25f, -2.5f, 0.0f);
            gl.glColor4f(0.0f, 0.0f, 1.0f, 0.33f);
            gl.glVertex3f(1.25f, -2.5f, 0.0f);
            gl.glColor4f(0.0f, 0.0f, 1.0f, 0.67f);
            gl.glVertex3f(1.25f, 0.0f, 0.0f);
            gl.glColor4f(0.0f, 0.0f, 1.0f, 1.0f);
            gl.glVertex3f(-1.25f, 0.0f, 0.0f);
            gl.glEnd();
            if (this.mod == 2) {
                gl.glTranslatef(0.0f, 0.0f, 0.5f);
                gl.glBegin(7);
                gl.glColor3f(1.0f, 1.0f, 1.0f);
                gl.glVertex3f(-1.5f, -1.5f, 0.0f);
                gl.glVertex3f(1.5f, -1.5f, 0.0f);
                gl.glColor3f(0.0f, 0.0f, 0.0f);
                gl.glVertex3f(1.5f, 1.5f, 0.0f);
                gl.glVertex3f(-1.5f, 1.5f, 0.0f);
                gl.glEnd();
            }
            gl.glDisable(3042);
        } else if (this.mod == 3 || this.mod == 4) {
            gl.glActiveTexture(33984);
            gl.glBindTexture(3553, this.textureID[0]);
            gl.glEnable(3553);
            switch (this.mod) {
                case 3: {
                    gl.glDisable(3042);
                    break;
                }
                case 4: {
                    gl.glBlendFunc(BLEND_FUNC[this.srcFunc], BLEND_FUNC[this.dstFunc]);
                    gl.glEnable(3042);
                }
            }
            gl.glBegin(7);
            gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            gl.glTexCoord2f(0.0f, 0.0f);
            gl.glVertex3f(-2.5f, -2.5f, -6.0f);
            gl.glTexCoord2f(1.0f, 0.0f);
            gl.glVertex3f(2.5f, -2.5f, -6.0f);
            gl.glTexCoord2f(1.0f, 1.0f);
            gl.glVertex3f(2.5f, 2.5f, -6.0f);
            gl.glTexCoord2f(0.0f, 1.0f);
            gl.glVertex3f(-2.5f, 2.5f, -6.0f);
            gl.glEnd();
        }
        if (this.promenaProjekcije) {
            this.postaviProjekciju(drawable);
            this.promenaProjekcije = false;
        }
        this.ispisiMeni(drawable);
    }

    @Override
    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glViewport(x, y, width, height);
        this.sirinaProzora = width;
        this.visinaProzora = height;
        this.proporcijaProzora = 1.0f * (float)this.sirinaProzora / (float)this.visinaProzora;
        this.postaviProjekciju(drawable);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 150: {
                break;
            }
            case 152: {
                break;
            }
            case 149: {
                if (this.tekuciUgaoVidnogPolja <= 1) break;
                --this.tekuciUgaoVidnogPolja;
                this.promenaProjekcije = true;
                break;
            }
            case 151: {
                if (this.tekuciUgaoVidnogPolja >= 179) break;
                ++this.tekuciUgaoVidnogPolja;
                this.promenaProjekcije = true;
                break;
            }
            case 27: {
                System.exit(0);
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                this.mod = e.getKeyCode() - 48;
                if (this.mod == 3) {
                    this.blendState = 1;
                    break;
                }
                this.blendState = 0;
                break;
            }
            case 97: {
                this.srcFunc = (this.srcFunc + 1) % BLEND_FUNC.length;
                break;
            }
            case 98: {
                this.dstFunc = (this.dstFunc + 1) % BLEND_FUNC.length;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void pisiTekst(String tekst, int x, int y) {
        this.txtRenderer.beginRendering(this.sirinaProzora, this.visinaProzora);
        this.txtRenderer.setColor(1.0f, 0.2f, 0.2f, 0.8f);
        this.txtRenderer.draw(tekst, x, y);
        this.txtRenderer.endRendering();
    }

    public void ispisiMeni(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glColor3f(0.0f, 0.0f, 0.0f);
        gl.glTranslated(-1.0, -1.0, 0.0);
        gl.glScaled(2.0 / (double)this.sirinaProzora, 2.0 / (double)this.visinaProzora, 1.0);
        this.pisiTekst("LEVO-DESNO: PROMENA UGLA VIDNOG POLJA " + this.tekuciUgaoVidnogPolja, 10, this.visinaProzora - 40);
        this.pisiTekst("F1: SRC OPERACIJA " + BLEND_FUNC_NAMES[this.srcFunc], 10, this.visinaProzora - 80);
        this.pisiTekst("F2: DST OPERACIJA " + BLEND_FUNC_NAMES[this.dstFunc], 10, this.visinaProzora - 120);
        this.pisiTekst("Mod iscrtavanja: " + this.mod, 10, this.visinaProzora - 160);
        this.pisiTekst("Stapanje: " + BLEND_STATE[this.blendState], 10, this.visinaProzora - 200);
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean LoadPNG(String filename) {
        boolean status = true;
        FileInputStream in = null;
        try {
            in = new FileInputStream(filename);
            PNGDecoder decoder = new PNGDecoder(in);
            this.imageWidth = decoder.getWidth();
            this.imageHeight = decoder.getHeight();
            this.pixelData = ByteBuffer.allocate(4 * this.imageWidth * this.imageHeight);
            decoder.decodeFlipped(this.pixelData, this.imageWidth * 4, PNGDecoder.Format.RGBA);
            this.pixelData.flip();
        }
        catch (IOException e) {
            status = false;
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return status;
    }

    private ByteBuffer makeTransparent(ByteBuffer pixelData) {
        for (int i = 0; i < this.imageHeight; ++i) {
            for (int j = 0; j < this.imageWidth; ++j) {
                pixelData.put(i * 4 * this.imageWidth + 4 * (j + 1) - 1, (byte)(((float)i * 0.3f / (float)this.imageHeight + (float)j * 0.7f / (float)this.imageWidth) * 255.0f));
            }
        }
        return pixelData;
    }

    private boolean LoadGLTexture(GLAutoDrawable drawable, String textureName, int[] storage) {
        boolean status = false;
        GL2 gl = drawable.getGL().getGL2();
        if (this.LoadPNG(textureName)) {
            ByteBuffer transparentImage = this.makeTransparent(this.pixelData);
            gl.glGenTextures(1, storage, 0);
            gl.glBindTexture(3553, storage[0]);
            gl.glTexImage2D(3553, 0, 6408, this.imageWidth, this.imageHeight, 0, 6408, 5121, transparentImage);
            gl.glTexParameteri(3553, 10241, 9729);
            gl.glTexParameteri(3553, 10240, 9729);
            status = true;
        }
        return status;
    }

    public static void main(String[] args) {
        new Stapanje_5();
    }
}

