/*
 * Decompiled with CFR 0.152.
 */
package jogl2.examples.tutorial;

import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.awt.TextRenderer;
import java.awt.Font;

public class Projekcija_1
implements GLEventListener,
KeyListener {
    private static final int ORTOGRAFSKA = 0;
    private static final int SA_PERSPEKTIVOM = 1;
    private static final String[] NAZIVI_PROJEKCIJA = new String[]{"ORTOGRAFSKA", "SA PERSPEKTIVOM"};
    private int tekucaProjekcija = 0;
    private final GLWindow prozor;
    private final String NASLOV = "(1) Projekcija";
    private int sirinaProzora = 600;
    private int visinaProzora = 800;
    private float proporcijaProzora;
    private final int SIRINA_ORTOGRAFSKA = 10;
    private static final int FPS = 30;
    private final FPSAnimator animator;
    private boolean promenaProjekcije = true;
    private TextRenderer txtRenderer;

    public Projekcija_1() {
        GLProfile glp = GLProfile.getDefault();
        System.out.println(glp.getGLImplBaseClassName());
        System.out.println(glp.getImplName());
        System.out.println(glp.getName());
        GLCapabilities caps = new GLCapabilities(glp);
        caps.setDepthBits(24);
        caps.setDoubleBuffered(true);
        this.prozor = GLWindow.create(caps);
        this.animator = new FPSAnimator(this.prozor, 30, true);
        this.prozor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDestroyNotify(WindowEvent arg0) {
                Projekcija_1.this.animator.stop();
                System.exit(0);
            }
        });
        this.prozor.addGLEventListener(this);
        this.prozor.addKeyListener(this);
        this.prozor.setSize(this.sirinaProzora, this.visinaProzora);
        this.prozor.setTitle("(1) Projekcija");
        this.prozor.setVisible(true);
        this.animator.start();
    }

    private void postaviProjekciju(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        switch (this.tekucaProjekcija) {
            case 0: {
                gl.glOrtho(-5.0, 5.0, -(10.0f * this.proporcijaProzora) / 2.0f, 10.0f * this.proporcijaProzora / 2.0f, 1.0, 11.0);
                break;
            }
            case 1: {
                gl.glFrustum(-1.0, 1.0, -1.0, 1.0, 1.0, 11.0);
            }
        }
        gl.glMatrixMode(5888);
    }

    @Override
    public void init(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
        gl.glShadeModel(7425);
        gl.glPolygonMode(1032, 6914);
        gl.glEnable(2929);
        this.txtRenderer = new TextRenderer(new Font("SansSerif", 1, 20));
        gl.glDrawBuffer(1032);
    }

    @Override
    public void dispose(GLAutoDrawable drawable) {
    }

    @Override
    public void display(GLAutoDrawable drawable) {
        if (this.promenaProjekcije) {
            this.promenaProjekcije = false;
            this.postaviProjekciju(drawable);
        }
        GL2 gl = drawable.getGL().getGL2();
        gl.glClear(16640);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this.crtajKocku(drawable, -2.0f, 2.0f, -4.0f, 2.0f);
        this.crtajKocku(drawable, 2.0f, -3.0f, -8.0f, 3.0f);
        this.crtajKocku(drawable, 2.0f, 2.0f, -10.0f, 1.0f);
        this.ispisiMeni(drawable);
    }

    @Override
    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glViewport(0, 0, width, height);
        this.sirinaProzora = width;
        this.visinaProzora = height;
        this.proporcijaProzora = 1.0f * (float)this.visinaProzora / (float)this.sirinaProzora;
        this.postaviProjekciju(drawable);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 149: 
            case 151: {
                this.tekucaProjekcija = 1 - this.tekucaProjekcija;
                this.promenaProjekcije = true;
                break;
            }
            case 27: {
                this.animator.stop();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void crtajKocku(GLAutoDrawable drawable, float x, float y, float z, float a) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glBegin(7);
        gl.glColor3f(1.0f, 0.0f, 0.0f);
        gl.glVertex3f(x - a / 2.0f, y - a / 2.0f, z - a / 2.0f);
        gl.glVertex3f(x + a / 2.0f, y - a / 2.0f, z - a / 2.0f);
        gl.glVertex3f(x + a / 2.0f, y + a / 2.0f, z - a / 2.0f);
        gl.glVertex3f(x - a / 2.0f, y + a / 2.0f, z - a / 2.0f);
        gl.glColor3f(0.0f, 1.0f, 0.0f);
        gl.glVertex3f(x + a / 2.0f, y - a / 2.0f, z - a / 2.0f);
        gl.glVertex3f(x + a / 2.0f, y - a / 2.0f, z + a / 2.0f);
        gl.glVertex3f(x + a / 2.0f, y + a / 2.0f, z + a / 2.0f);
        gl.glVertex3f(x + a / 2.0f, y + a / 2.0f, z - a / 2.0f);
        gl.glColor3f(0.0f, 0.0f, 1.0f);
        gl.glVertex3f(x - a / 2.0f, y + a / 2.0f, z - a / 2.0f);
        gl.glVertex3f(x + a / 2.0f, y + a / 2.0f, z - a / 2.0f);
        gl.glVertex3f(x + a / 2.0f, y + a / 2.0f, z + a / 2.0f);
        gl.glVertex3f(x - a / 2.0f, y + a / 2.0f, z + a / 2.0f);
        gl.glColor3f(1.0f, 0.5f, 0.0f);
        gl.glVertex3f(x - a / 2.0f, y - a / 2.0f, z + a / 2.0f);
        gl.glVertex3f(x - a / 2.0f, y - a / 2.0f, z - a / 2.0f);
        gl.glVertex3f(x - a / 2.0f, y + a / 2.0f, z - a / 2.0f);
        gl.glVertex3f(x - a / 2.0f, y + a / 2.0f, z + a / 2.0f);
        gl.glColor3f(1.0f, 0.0f, 1.0f);
        gl.glVertex3f(x - a / 2.0f, y - a / 2.0f, z - a / 2.0f);
        gl.glVertex3f(x + a / 2.0f, y - a / 2.0f, z - a / 2.0f);
        gl.glVertex3f(x + a / 2.0f, y - a / 2.0f, z + a / 2.0f);
        gl.glVertex3f(x - a / 2.0f, y - a / 2.0f, z + a / 2.0f);
        gl.glColor3f(0.7f, 0.0f, 1.0f);
        gl.glVertex3f(x + a / 2.0f, y + a / 2.0f, z + a / 2.0f);
        gl.glVertex3f(x + a / 2.0f, y - a / 2.0f, z + a / 2.0f);
        gl.glVertex3f(x - a / 2.0f, y - a / 2.0f, z + a / 2.0f);
        gl.glVertex3f(x - a / 2.0f, y + a / 2.0f, z + a / 2.0f);
        gl.glEnd();
    }

    public void pisiTekst(String tekst, int x, int y) {
        this.txtRenderer.beginRendering(this.sirinaProzora, this.visinaProzora);
        this.txtRenderer.setColor(1.0f, 0.2f, 0.2f, 0.8f);
        this.txtRenderer.draw(tekst, x, y);
        this.txtRenderer.endRendering();
    }

    public void ispisiMeni(GLAutoDrawable drawable) {
        this.pisiTekst("LEVO-DESNO: PROMENA PROJEKCIJE " + NAZIVI_PROJEKCIJA[this.tekucaProjekcija], 10, this.visinaProzora - 20);
    }

    public static void main(String[] args) {
        new Projekcija_1();
    }
}

