/*
 * Decompiled with CFR 0.152.
 */
package jogl2.examples.tutorial;

import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.awt.TextRenderer;
import java.awt.Font;

public class Ogledalo_6
implements GLEventListener,
KeyListener {
    private final GLWindow prozor;
    private static final String NASLOV = "(6) Ogledalo";
    private int sirinaProzora = 600;
    private int visinaProzora = 500;
    private float proporcijaProzora;
    private static final int FPS = 60;
    private final FPSAnimator animator;
    private TextRenderer txtRenderer;
    private GLU glu;
    private boolean promenaProjekcije = false;
    private int tekuciUgaoVidnogPolja = 90;
    private int tekuciUgaoRotacije = 0;
    private int pozicijaPosmatraca = 0;

    public Ogledalo_6() {
        GLProfile glp = GLProfile.getDefault();
        GLCapabilities caps = new GLCapabilities(glp);
        caps.setAlphaBits(8);
        caps.setDepthBits(24);
        caps.setDoubleBuffered(true);
        caps.setStencilBits(8);
        this.prozor = GLWindow.create(caps);
        this.animator = new FPSAnimator(this.prozor, 60, true);
        this.prozor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDestroyNotify(WindowEvent arg0) {
                System.exit(0);
            }
        });
        this.prozor.addGLEventListener(this);
        this.prozor.addKeyListener(this);
        this.prozor.setSize(this.sirinaProzora, this.visinaProzora);
        this.prozor.setTitle(NASLOV);
        this.prozor.setVisible(true);
        this.animator.start();
    }

    public void postaviProjekciju(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.glu.gluPerspective(this.tekuciUgaoVidnogPolja, this.proporcijaProzora, 1.0f, 80.0f);
        gl.glMatrixMode(5888);
    }

    @Override
    public void init(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        gl.glClearStencil(0);
        gl.glShadeModel(7425);
        gl.glPolygonMode(1032, 6914);
        gl.glEnable(2929);
        this.txtRenderer = new TextRenderer(new Font("SansSerif", 1, 20));
        this.glu = GLU.createGLU(gl);
    }

    @Override
    public void dispose(GLAutoDrawable drawable) {
    }

    @Override
    public void display(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glClear(17664);
        if (this.promenaProjekcije) {
            this.postaviProjekciju(drawable);
            this.promenaProjekcije = false;
        }
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this.postaviPosmatraca();
        this.crtajScenuBezOgledala(drawable);
        this.crtajOgledalo(drawable);
        this.ispisiMeni(drawable);
    }

    @Override
    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glViewport(x, y, width, height);
        this.sirinaProzora = width;
        this.visinaProzora = height;
        this.proporcijaProzora = 1.0f * (float)this.sirinaProzora / (float)this.visinaProzora;
        this.postaviProjekciju(drawable);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 150: {
                ++this.tekuciUgaoRotacije;
                break;
            }
            case 152: {
                --this.tekuciUgaoRotacije;
                break;
            }
            case 149: {
                if (this.tekuciUgaoVidnogPolja <= 1) break;
                --this.tekuciUgaoVidnogPolja;
                this.promenaProjekcije = true;
                break;
            }
            case 151: {
                if (this.tekuciUgaoVidnogPolja >= 179) break;
                ++this.tekuciUgaoVidnogPolja;
                this.promenaProjekcije = true;
                break;
            }
            case 27: {
                this.animator.stop();
                System.exit(0);
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                this.pozicijaPosmatraca = e.getKeyCode() - 48;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void crtajKocku(GLAutoDrawable drawable, float x, float y, float z, float a) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glTranslatef(x, y, z);
        gl.glScalef(a, a, a);
        gl.glRotatef(this.tekuciUgaoRotacije, 1.0f, 1.0f, 1.0f);
        gl.glBegin(7);
        gl.glColor3f(1.0f, 0.0f, 0.0f);
        gl.glVertex3f(-0.5f, -0.5f, -0.5f);
        gl.glVertex3f(0.5f, -0.5f, -0.5f);
        gl.glVertex3f(0.5f, 0.5f, -0.5f);
        gl.glVertex3f(-0.5f, 0.5f, -0.5f);
        gl.glColor3f(0.0f, 1.0f, 0.0f);
        gl.glVertex3f(0.5f, -0.5f, -0.5f);
        gl.glVertex3f(0.5f, -0.5f, 0.5f);
        gl.glVertex3f(0.5f, 0.5f, 0.5f);
        gl.glVertex3f(0.5f, 0.5f, -0.5f);
        gl.glColor3f(0.0f, 0.0f, 1.0f);
        gl.glVertex3f(-0.5f, 0.5f, -0.5f);
        gl.glVertex3f(0.5f, 0.5f, -0.5f);
        gl.glVertex3f(0.5f, 0.5f, 0.5f);
        gl.glVertex3f(-0.5f, 0.5f, 0.5f);
        gl.glColor3f(1.0f, 0.5f, 0.0f);
        gl.glVertex3f(-0.5f, -0.5f, 0.5f);
        gl.glVertex3f(-0.5f, -0.5f, -0.5f);
        gl.glVertex3f(-0.5f, 0.5f, -0.5f);
        gl.glVertex3f(-0.5f, 0.5f, 0.5f);
        gl.glColor3f(1.0f, 0.0f, 1.0f);
        gl.glVertex3f(-0.5f, -0.5f, -0.5f);
        gl.glVertex3f(0.5f, -0.5f, -0.5f);
        gl.glVertex3f(0.5f, -0.5f, 0.5f);
        gl.glVertex3f(-0.5f, -0.5f, 0.5f);
        gl.glColor3f(0.7f, 0.0f, 1.0f);
        gl.glVertex3f(0.5f, 0.5f, 0.5f);
        gl.glVertex3f(0.5f, -0.5f, 0.5f);
        gl.glVertex3f(-0.5f, -0.5f, 0.5f);
        gl.glVertex3f(-0.5f, 0.5f, 0.5f);
        gl.glEnd();
        gl.glPopMatrix();
    }

    private void postaviPosmatraca() {
        switch (this.pozicijaPosmatraca) {
            case 0: {
                this.glu.gluLookAt(-7.1f, 7.1f, 7.1f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
                break;
            }
            case 1: {
                this.glu.gluLookAt(7.1f, 7.1f, 7.1f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
                break;
            }
            case 2: {
                this.glu.gluLookAt(7.1f, 7.1f, -7.1f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
                break;
            }
            case 3: {
                this.glu.gluLookAt(-7.1f, 7.1f, -7.1f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
                break;
            }
            case 4: {
                this.glu.gluLookAt(1.0f, 50.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
            }
        }
    }

    private void crtajScenuBezOgledala(GLAutoDrawable drawable) {
        this.crtajPodlogu(drawable, 20.0f);
        this.crtajKocku(drawable, -2.0f, 2.0f, -4.0f, 2.0f);
        this.crtajKocku(drawable, 2.0f, -3.0f, -8.0f, 3.0f);
        this.crtajKocku(drawable, 2.0f, 2.0f, -3.0f, 1.0f);
    }

    private void crtajPodlogu(GLAutoDrawable drawable, float a) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glBegin(7);
        gl.glColor3f(1.0f, 0.0f, 0.0f);
        gl.glVertex3f(-a / 2.0f, -5.0f, -a / 2.0f);
        gl.glColor3f(0.0f, 1.0f, 0.0f);
        gl.glVertex3f(a / 2.0f, -5.0f, -a / 2.0f);
        gl.glColor3f(0.0f, 0.0f, 1.0f);
        gl.glVertex3f(a / 2.0f, -5.0f, a / 2.0f);
        gl.glColor3f(0.4f, 0.4f, 0.4f);
        gl.glVertex3f(-a / 2.0f, -5.0f, a / 2.0f);
        gl.glEnd();
    }

    private void crtajOgledalo(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glDepthMask(false);
        gl.glStencilMask(-1);
        gl.glEnable(2960);
        gl.glStencilFunc(519, 0, -1);
        gl.glStencilOp(7680, 7680, 7682);
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        gl.glPushMatrix();
        gl.glRotated(this.tekuciUgaoRotacije, 0.0, 1.0, 0.0);
        gl.glRotated(10.0, 0.0, 0.0, 1.0);
        gl.glTranslated(15.0, 0.0, 0.0);
        gl.glRotated(-90.0, 0.0, 1.0, 0.0);
        gl.glBegin(7);
        gl.glColor4f(0.0f, 0.0f, 0.0f, 0.1f);
        gl.glVertex3f(-5.0f, -5.0f, 0.0f);
        gl.glVertex3f(5.0f, -5.0f, 0.0f);
        gl.glVertex3f(5.0f, 5.0f, 0.0f);
        gl.glVertex3f(-5.0f, 5.0f, 0.0f);
        gl.glEnd();
        gl.glStencilFunc(517, 0, -1);
        gl.glStencilOp(7680, 7680, 7680);
        gl.glRotated(90.0, 0.0, 1.0, 0.0);
        gl.glScaled(-1.0, 1.0, 1.0);
        gl.glTranslated(-15.0, 0.0, 0.0);
        gl.glRotated(-10.0, 0.0, 0.0, 1.0);
        gl.glRotated(-this.tekuciUgaoRotacije, 0.0, 1.0, 0.0);
        gl.glDepthMask(true);
        this.crtajScenuBezOgledala(drawable);
        gl.glDisable(3042);
        gl.glDisable(2960);
        gl.glPopMatrix();
    }

    public void pisiTekst(String tekst, int x, int y) {
        this.txtRenderer.beginRendering(this.sirinaProzora, this.visinaProzora);
        this.txtRenderer.setColor(1.0f, 0.2f, 0.2f, 0.8f);
        this.txtRenderer.draw(tekst, x, y);
        this.txtRenderer.endRendering();
    }

    public void ispisiMeni(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glColor3f(0.0f, 0.0f, 0.0f);
        gl.glTranslated(-1.0, -1.0, 0.0);
        gl.glScaled(2.0 / (double)this.sirinaProzora, 2.0 / (double)this.visinaProzora, 1.0);
        this.pisiTekst("LEVO-DESNO: PROMENA UGLA VIDNOG POLJA " + this.tekuciUgaoVidnogPolja, 10, this.visinaProzora - 20);
        this.pisiTekst("GORE-DOLE: PROMENA ROTACIJE KOCKI I OGLEDALA " + this.tekuciUgaoRotacije, 10, this.visinaProzora - 40);
        this.pisiTekst("0-4: PROMENA POZICIJE POSMATRACA", 10, this.visinaProzora - 60);
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
    }

    public static void main(String[] args) {
        new Ogledalo_6();
    }
}

