/*
 * Decompiled with CFR 0.152.
 */
package jogl2.examples.tutorial;

import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.awt.TextRenderer;
import de.matthiasmann.twl.utils.PNGDecoder;
import java.awt.Font;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class JednostavnoTeksturiranje_4
implements GLEventListener,
KeyListener {
    private final GLWindow prozor;
    private static final String NASLOV = "(4) Jednostavno Teksturiranje";
    private int sirinaProzora = 800;
    private int visinaProzora = 800;
    private float proporcijaProzora;
    private static final int FPS = 60;
    private final FPSAnimator animator;
    private TextRenderer txtRenderer;
    private boolean promenaProjekcije = false;
    private boolean promenaTeksture = false;
    private int tekuciUgaoVidnogPolja = 60;
    private int tekuciUgaoRotacije = 0;
    private float tekucaVisinaKamere = 10.0f;
    private final float inkrementVisine = 2.0f;
    private boolean pauza = true;
    private long prethodnoVreme = 0L;
    private static final int BROJ_FILTARA = 6;
    private static final String[] NAZIVI_FILTARA = new String[]{"min = NEAREST mag = NEAREST", "min = LINEAR mag = LINEAR", "min = NEAREST-NEAREST mag = LINEAR", "min = NEAREST-LINEAR mag = LINEAR", "min = LINEAR-NEAREST mag = LINEAR", "min = LINEAR-LINEAR mag = LINEAR"};
    private int tekucaTekstura = 0;
    private final int[] textureID = new int[6];
    private GLU glu;
    private ByteBuffer pixelData;
    private int imageWidth;
    private int imageHeight;

    public JednostavnoTeksturiranje_4() {
        GLProfile glp = GLProfile.getGL2GL3();
        GLCapabilities caps = new GLCapabilities(glp);
        caps.setAlphaBits(8);
        caps.setDepthBits(24);
        caps.setDoubleBuffered(true);
        this.prozor = GLWindow.create(caps);
        this.animator = new FPSAnimator(this.prozor, 60, false);
        this.prozor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDestroyNotify(WindowEvent arg0) {
                JednostavnoTeksturiranje_4.this.animator.stop();
                System.exit(0);
            }
        });
        this.prozor.addGLEventListener(this);
        this.prozor.addKeyListener(this);
        this.prozor.setSize(this.sirinaProzora, this.visinaProzora);
        this.prozor.setTitle(NASLOV);
        this.prozor.setVisible(true);
        this.animator.start();
    }

    public void postaviProjekciju(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.glu.gluPerspective(this.tekuciUgaoVidnogPolja, this.proporcijaProzora, 1.0f, 1200.0f);
        gl.glMatrixMode(5888);
    }

    @Override
    public void init(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
        gl.glShadeModel(7425);
        gl.glPolygonMode(1032, 6914);
        gl.glEnable(2929);
        gl.glActiveTexture(33984);
        gl.glEnable(3553);
        this.txtRenderer = new TextRenderer(new Font("SansSerif", 1, 30));
        this.glu = GLU.createGLU(gl);
        if (!this.LoadGLTexture(drawable, "src/slike/sah.png", this.textureID, 0, 9728, 9728)) {
            return;
        }
        if (!this.LoadGLTexture(drawable, "src/slike/sah.png", this.textureID, 1, 9729, 9729)) {
            return;
        }
        if (!this.LoadGLTexture(drawable, "src/slike/sah.png", this.textureID, 2, 9984, 9729)) {
            return;
        }
        if (!this.LoadGLTexture(drawable, "src/slike/sah.png", this.textureID, 3, 9986, 9729)) {
            return;
        }
        if (!this.LoadGLTexture(drawable, "src/slike/sah.png", this.textureID, 4, 9985, 9729)) {
            return;
        }
        if (!this.LoadGLTexture(drawable, "src/slike/sah.png", this.textureID, 5, 9987, 9729)) {
            return;
        }
        gl.glBindTexture(3553, this.textureID[0]);
    }

    @Override
    public void dispose(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glDeleteTextures(this.textureID.length, IntBuffer.wrap(this.textureID));
    }

    @Override
    public void display(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        if (this.promenaProjekcije) {
            this.postaviProjekciju(drawable);
            this.promenaProjekcije = false;
        }
        if (this.promenaTeksture) {
            gl.glBindTexture(3553, this.textureID[this.tekucaTekstura]);
            this.promenaTeksture = false;
        }
        if (!this.pauza) {
            ++this.tekuciUgaoRotacije;
        }
        gl.glClear(16640);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this.glu.gluLookAt(0.0f, this.tekucaVisinaKamere, 20.0f, 0.0f, -10.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.crtajKocku(drawable, 0.0f, -10.0f, 0.0f, 5.0f);
        this.crtajPodlogu(drawable, 1000.0f, 1000.0f);
        this.ispisiMeni(drawable);
    }

    @Override
    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glViewport(x, y, width, height);
        this.sirinaProzora = width;
        this.visinaProzora = height;
        this.proporcijaProzora = 1.0f * (float)this.visinaProzora / (float)this.sirinaProzora;
        this.postaviProjekciju(drawable);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 150: {
                this.tekucaVisinaKamere += 2.0f;
                break;
            }
            case 152: {
                this.tekucaVisinaKamere -= 2.0f;
                break;
            }
            case 149: {
                if (this.tekuciUgaoVidnogPolja <= 1) break;
                --this.tekuciUgaoVidnogPolja;
                this.promenaProjekcije = true;
                break;
            }
            case 151: {
                if (this.tekuciUgaoVidnogPolja >= 179) break;
                ++this.tekuciUgaoVidnogPolja;
                this.promenaProjekcije = true;
                break;
            }
            case 27: {
                System.exit(0);
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                break;
            }
            case 97: {
                this.tekucaTekstura = (this.tekucaTekstura - 1 + NAZIVI_FILTARA.length) % NAZIVI_FILTARA.length;
                this.promenaTeksture = true;
                break;
            }
            case 98: {
                this.tekucaTekstura = (this.tekucaTekstura + 1) % NAZIVI_FILTARA.length;
                this.promenaTeksture = true;
                break;
            }
            case 32: {
                this.pauza = !this.pauza;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void crtajKocku(GLAutoDrawable drawable, float x, float y, float z, float a) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glTranslatef(x, y, z);
        gl.glScalef(a, a, a);
        gl.glRotatef(this.tekuciUgaoRotacije, 1.0f, 1.0f, 1.0f);
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f(-0.5f, -0.5f, -0.5f);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3f(0.5f, -0.5f, -0.5f);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f(0.5f, 0.5f, -0.5f);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f(-0.5f, 0.5f, -0.5f);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f(0.5f, -0.5f, -0.5f);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3f(0.5f, -0.5f, 0.5f);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f(0.5f, 0.5f, 0.5f);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f(0.5f, 0.5f, -0.5f);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f(-0.5f, 0.5f, -0.5f);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3f(0.5f, 0.5f, -0.5f);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f(0.5f, 0.5f, 0.5f);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f(-0.5f, 0.5f, 0.5f);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f(-0.5f, -0.5f, 0.5f);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3f(-0.5f, -0.5f, -0.5f);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f(-0.5f, 0.5f, -0.5f);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f(-0.5f, 0.5f, 0.5f);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f(-0.5f, -0.5f, -0.5f);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3f(0.5f, -0.5f, -0.5f);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f(0.5f, -0.5f, 0.5f);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f(-0.5f, -0.5f, 0.5f);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f(-0.5f, -0.5f, 0.5f);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3f(0.5f, -0.5f, 0.5f);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f(0.5f, 0.5f, 0.5f);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f(-0.5f, 0.5f, 0.5f);
        gl.glEnd();
        gl.glPopMatrix();
    }

    private void crtajPodlogu(GLAutoDrawable prozor, float a, float b) {
        GL2 gl = prozor.getGL().getGL2();
        float texDim = 100.0f;
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glTranslatef(0.0f, -15.0f, 0.0f);
        gl.glRotatef(-90.0f, 1.0f, 0.0f, 0.0f);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, texDim);
        gl.glVertex2f(-a / 2.0f, b / 2.0f);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex2f(-a / 2.0f, -b / 2.0f);
        gl.glTexCoord2f(texDim, 0.0f);
        gl.glVertex2f(a / 2.0f, -b / 2.0f);
        gl.glTexCoord2f(texDim, texDim);
        gl.glVertex2f(a / 2.0f, b / 2.0f);
        gl.glEnd();
        gl.glPopMatrix();
    }

    public void pisiTekst(String tekst, int x, int y) {
        this.txtRenderer.beginRendering(this.sirinaProzora, this.visinaProzora);
        this.txtRenderer.setColor(1.0f, 0.2f, 0.2f, 0.8f);
        this.txtRenderer.draw(tekst, x, y);
        this.txtRenderer.endRendering();
    }

    public void ispisiMeni(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glColor3f(0.0f, 0.0f, 0.0f);
        gl.glTranslated(-1.0, -1.0, 0.0);
        gl.glScaled(2.0 / (double)this.sirinaProzora, 2.0 / (double)this.visinaProzora, 1.0);
        this.pisiTekst("LEVO-DESNO: PROMENA UGLA VIDNOG POLJA " + this.tekuciUgaoVidnogPolja, 10, this.visinaProzora - 40);
        this.pisiTekst("RAZMAK: PAUZA ", 10, this.visinaProzora - 80);
        this.pisiTekst("F1 - F2: FILTAR " + NAZIVI_FILTARA[this.tekucaTekstura], 10, this.visinaProzora - 120);
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean LoadPNG(String filename) {
        boolean status = false;
        FileInputStream in = null;
        try {
            in = new FileInputStream(filename);
            PNGDecoder decoder = new PNGDecoder(in);
            this.imageWidth = decoder.getWidth();
            this.imageHeight = decoder.getHeight();
            this.pixelData = ByteBuffer.allocate(4 * this.imageWidth * this.imageHeight);
            decoder.decodeFlipped(this.pixelData, this.imageWidth * 4, PNGDecoder.Format.RGBA);
            this.pixelData.flip();
            status = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return status;
    }

    private boolean LoadGLTexture(GLAutoDrawable drawable, String textureName, int[] storage, int ind, int minFilter, int magFilter) {
        boolean status = false;
        GL2 gl = drawable.getGL().getGL2();
        if (this.LoadPNG(textureName)) {
            gl.glGenTextures(1, storage, ind);
            gl.glBindTexture(3553, storage[ind]);
            if (minFilter == 9984 || minFilter == 9986 || minFilter == 9985 || minFilter == 9987) {
                gl.glTexParameteri(3553, 33169, 1);
            }
            gl.glTexImage2D(3553, 0, 6407, this.imageWidth, this.imageHeight, 0, 6408, 5121, this.pixelData);
            gl.glTexParameteri(3553, 10241, minFilter);
            gl.glTexParameteri(3553, 10240, magFilter);
            status = true;
        }
        return status;
    }

    public static void main(String[] args) {
        new JednostavnoTeksturiranje_4();
    }
}

