/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import org.joml.Matrix3d;
import org.joml.Matrix3f;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4x3d;
import org.joml.Matrix4x3f;
import org.joml.Quaternionf;
import sun.misc.Unsafe;

abstract class MemUtil {
    private static final boolean nounsafe = MemUtil.hasOption("joml.nounsafe");
    static final MemUtil INSTANCE = MemUtil.createInstance();
    static /* synthetic */ Class class$java$nio$Buffer;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$sun$misc$Unsafe;
    static /* synthetic */ Class class$org$joml$Matrix4f;
    static /* synthetic */ Class class$org$joml$Matrix4x3f;
    static /* synthetic */ Class class$org$joml$Matrix3f;

    MemUtil() {
    }

    private static boolean hasOption(String option) {
        String v = System.getProperty(option);
        if (v == null) {
            return false;
        }
        if (v.trim().length() == 0) {
            return true;
        }
        return Boolean.valueOf(v);
    }

    private static final MemUtil createInstance() {
        MemUtil accessor;
        try {
            accessor = nounsafe ? new MemUtilNIO() : new MemUtilUnsafe();
        }
        catch (Throwable e) {
            accessor = new MemUtilNIO();
        }
        return accessor;
    }

    abstract void put(Matrix4f var1, int var2, FloatBuffer var3);

    abstract void put(Matrix4f var1, int var2, ByteBuffer var3);

    abstract void put(Matrix4x3f var1, int var2, FloatBuffer var3);

    abstract void put(Matrix4x3f var1, int var2, ByteBuffer var3);

    abstract void put4x4(Matrix4x3f var1, int var2, FloatBuffer var3);

    abstract void put4x4(Matrix4x3f var1, int var2, ByteBuffer var3);

    abstract void putTransposed(Matrix4f var1, int var2, FloatBuffer var3);

    abstract void putTransposed(Matrix4f var1, int var2, ByteBuffer var3);

    abstract void put4x3Transposed(Matrix4f var1, int var2, FloatBuffer var3);

    abstract void put4x3Transposed(Matrix4f var1, int var2, ByteBuffer var3);

    abstract void putTransposed(Matrix4x3f var1, int var2, FloatBuffer var3);

    abstract void putTransposed(Matrix4x3f var1, int var2, ByteBuffer var3);

    abstract void put(Matrix4d var1, int var2, DoubleBuffer var3);

    abstract void put(Matrix4d var1, int var2, ByteBuffer var3);

    abstract void put(Matrix4x3d var1, int var2, DoubleBuffer var3);

    abstract void put(Matrix4x3d var1, int var2, ByteBuffer var3);

    abstract void putf(Matrix4d var1, int var2, FloatBuffer var3);

    abstract void putf(Matrix4d var1, int var2, ByteBuffer var3);

    abstract void putf(Matrix4x3d var1, int var2, FloatBuffer var3);

    abstract void putf(Matrix4x3d var1, int var2, ByteBuffer var3);

    abstract void putTransposed(Matrix4d var1, int var2, DoubleBuffer var3);

    abstract void putTransposed(Matrix4d var1, int var2, ByteBuffer var3);

    abstract void put4x3Transposed(Matrix4d var1, int var2, DoubleBuffer var3);

    abstract void put4x3Transposed(Matrix4d var1, int var2, ByteBuffer var3);

    abstract void putTransposed(Matrix4x3d var1, int var2, DoubleBuffer var3);

    abstract void putTransposed(Matrix4x3d var1, int var2, ByteBuffer var3);

    abstract void putfTransposed(Matrix4d var1, int var2, FloatBuffer var3);

    abstract void putfTransposed(Matrix4d var1, int var2, ByteBuffer var3);

    abstract void putfTransposed(Matrix4x3d var1, int var2, FloatBuffer var3);

    abstract void putfTransposed(Matrix4x3d var1, int var2, ByteBuffer var3);

    abstract void put(Matrix3f var1, int var2, FloatBuffer var3);

    abstract void put(Matrix3f var1, int var2, ByteBuffer var3);

    abstract void put(Matrix3d var1, int var2, DoubleBuffer var3);

    abstract void put(Matrix3d var1, int var2, ByteBuffer var3);

    abstract void putf(Matrix3d var1, int var2, FloatBuffer var3);

    abstract void putf(Matrix3d var1, int var2, ByteBuffer var3);

    abstract void get(Matrix4f var1, int var2, FloatBuffer var3);

    abstract void get(Matrix4f var1, int var2, ByteBuffer var3);

    abstract void get(Matrix4x3f var1, int var2, FloatBuffer var3);

    abstract void get(Matrix4x3f var1, int var2, ByteBuffer var3);

    abstract void get(Matrix4d var1, int var2, DoubleBuffer var3);

    abstract void get(Matrix4d var1, int var2, ByteBuffer var3);

    abstract void get(Matrix4x3d var1, int var2, DoubleBuffer var3);

    abstract void get(Matrix4x3d var1, int var2, ByteBuffer var3);

    abstract void getf(Matrix4d var1, int var2, FloatBuffer var3);

    abstract void getf(Matrix4d var1, int var2, ByteBuffer var3);

    abstract void getf(Matrix4x3d var1, int var2, FloatBuffer var3);

    abstract void getf(Matrix4x3d var1, int var2, ByteBuffer var3);

    abstract void get(Matrix3f var1, int var2, FloatBuffer var3);

    abstract void get(Matrix3f var1, int var2, ByteBuffer var3);

    abstract void get(Matrix3d var1, int var2, DoubleBuffer var3);

    abstract void get(Matrix3d var1, int var2, ByteBuffer var3);

    abstract void getf(Matrix3d var1, int var2, FloatBuffer var3);

    abstract void getf(Matrix3d var1, int var2, ByteBuffer var3);

    abstract void copy(Matrix4f var1, Matrix4f var2);

    abstract void copy(Matrix4x3f var1, Matrix4x3f var2);

    abstract void copy(Matrix4f var1, Matrix4x3f var2);

    abstract void copy(Matrix3f var1, Matrix3f var2);

    abstract void copy(Matrix3f var1, Matrix4f var2);

    abstract void copy(Matrix4f var1, Matrix3f var2);

    abstract void copy(Matrix3f var1, Matrix4x3f var2);

    abstract void copy3x3(Matrix4f var1, Matrix4f var2);

    abstract void copy4x3(Matrix4f var1, Matrix4f var2);

    abstract void copy4x3(Matrix4x3f var1, Matrix4f var2);

    abstract void identity(Matrix4f var1);

    abstract void identity(Matrix4x3f var1);

    abstract void identity(Matrix3f var1);

    abstract void swap(Matrix4f var1, Matrix4f var2);

    abstract void swap(Matrix4x3f var1, Matrix4x3f var2);

    abstract void swap(Matrix3f var1, Matrix3f var2);

    abstract void zero(Matrix4f var1);

    abstract void zero(Matrix4x3f var1);

    abstract void zero(Matrix3f var1);

    abstract void putMatrix3f(Quaternionf var1, int var2, ByteBuffer var3);

    abstract void putMatrix3f(Quaternionf var1, int var2, FloatBuffer var3);

    abstract void putMatrix4f(Quaternionf var1, int var2, ByteBuffer var3);

    abstract void putMatrix4f(Quaternionf var1, int var2, FloatBuffer var3);

    abstract void putMatrix4x3f(Quaternionf var1, int var2, ByteBuffer var3);

    abstract void putMatrix4x3f(Quaternionf var1, int var2, FloatBuffer var3);

    static final class MemUtilUnsafe
    extends MemUtil {
        private static final Unsafe UNSAFE = MemUtilUnsafe.getUnsafeInstance();
        private static final long ADDRESS;
        private static final long Matrix3f_m00;
        private static final long Matrix4f_m00;
        private static final long Matrix4x3f_m00;

        MemUtilUnsafe() {
        }

        private static long checkMatrix4f() throws NoSuchFieldException, SecurityException {
            Field f = (class$org$joml$Matrix4f == null ? (class$org$joml$Matrix4f = MemUtil.class$("org.joml.Matrix4f")) : class$org$joml$Matrix4f).getDeclaredField("m00");
            long Matrix4f_m00 = UNSAFE.objectFieldOffset(f);
            for (int i = 1; i < 16; ++i) {
                int c = i >>> 2;
                int r = i & 3;
                f = (class$org$joml$Matrix4f == null ? MemUtil.class$("org.joml.Matrix4f") : class$org$joml$Matrix4f).getDeclaredField("m" + c + r);
                long offset = UNSAFE.objectFieldOffset(f);
                if (offset == Matrix4f_m00 + (long)(i << 2)) continue;
                throw new UnsupportedOperationException();
            }
            return Matrix4f_m00;
        }

        private static long checkMatrix4x3f() throws NoSuchFieldException, SecurityException {
            Field f = (class$org$joml$Matrix4x3f == null ? (class$org$joml$Matrix4x3f = MemUtil.class$("org.joml.Matrix4x3f")) : class$org$joml$Matrix4x3f).getDeclaredField("m00");
            long Matrix4x3f_m00 = UNSAFE.objectFieldOffset(f);
            for (int i = 1; i < 12; ++i) {
                int c = i / 3;
                int r = i % 3;
                f = (class$org$joml$Matrix4x3f == null ? MemUtil.class$("org.joml.Matrix4x3f") : class$org$joml$Matrix4x3f).getDeclaredField("m" + c + r);
                long offset = UNSAFE.objectFieldOffset(f);
                if (offset == Matrix4x3f_m00 + (long)(i << 2)) continue;
                throw new UnsupportedOperationException();
            }
            return Matrix4x3f_m00;
        }

        private static long checkMatrix3f() throws NoSuchFieldException, SecurityException {
            Field f = (class$org$joml$Matrix3f == null ? (class$org$joml$Matrix3f = MemUtil.class$("org.joml.Matrix3f")) : class$org$joml$Matrix3f).getDeclaredField("m00");
            long Matrix3f_m00 = UNSAFE.objectFieldOffset(f);
            for (int i = 1; i < 9; ++i) {
                int c = i / 3;
                int r = i % 3;
                f = (class$org$joml$Matrix3f == null ? MemUtil.class$("org.joml.Matrix3f") : class$org$joml$Matrix3f).getDeclaredField("m" + c + r);
                long offset = UNSAFE.objectFieldOffset(f);
                if (offset == Matrix3f_m00 + (long)(i << 2)) continue;
                throw new UnsupportedOperationException();
            }
            return Matrix3f_m00;
        }

        private static final Field getDeclaredField(Class root, String fieldName) throws NoSuchFieldException {
            Class type = root;
            do {
                try {
                    Field field = type.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException e) {
                    type = type.getSuperclass();
                }
                catch (SecurityException e) {
                    type = type.getSuperclass();
                }
            } while (type != null);
            throw new NoSuchFieldException(fieldName + " does not exist in " + root.getName() + " or any of its superclasses.");
        }

        private static final Unsafe getUnsafeInstance() throws SecurityException {
            Field[] fields = (class$sun$misc$Unsafe == null ? (class$sun$misc$Unsafe = MemUtil.class$("sun.misc.Unsafe")) : class$sun$misc$Unsafe).getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                int modifiers;
                Field field = fields[i];
                if (!field.getType().equals(class$sun$misc$Unsafe == null ? MemUtil.class$("sun.misc.Unsafe") : class$sun$misc$Unsafe) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
                field.setAccessible(true);
                try {
                    return (Unsafe)field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    break;
                }
            }
            throw new UnsupportedOperationException();
        }

        private final long addressOf(Buffer buffer) {
            return UNSAFE.getLong(buffer, ADDRESS);
        }

        private final void put(Matrix4f m, long destAddr) {
            for (int i = 0; i < 8; ++i) {
                UNSAFE.putOrderedLong(null, destAddr + (long)(i << 3), UNSAFE.getLong(m, Matrix4f_m00 + (long)(i << 3)));
            }
        }

        private final void put(Matrix4x3f m, long destAddr) {
            for (int i = 0; i < 6; ++i) {
                UNSAFE.putOrderedLong(null, destAddr + (long)(i << 3), UNSAFE.getLong(m, Matrix4x3f_m00 + (long)(i << 3)));
            }
        }

        private final void put4x4(Matrix4x3f m, long destAddr) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(null, destAddr + (long)(i << 4), UNSAFE.getLong(m, Matrix4x3f_m00 + (long)(12 * i)));
                long lng = (long)UNSAFE.getInt(m, Matrix4x3f_m00 + 8L + (long)(12 * i)) & 0xFFFFFFFFL;
                UNSAFE.putOrderedLong(null, destAddr + 8L + (long)(i << 4), lng);
            }
            UNSAFE.putFloat(null, destAddr + 60L, 1.0f);
        }

        private final void putTransposed(Matrix4f m, long destAddr) {
            UNSAFE.putFloat(null, destAddr, m.m00);
            UNSAFE.putFloat(null, destAddr + 4L, m.m10);
            UNSAFE.putFloat(null, destAddr + 8L, m.m20);
            UNSAFE.putFloat(null, destAddr + 12L, m.m30);
            UNSAFE.putFloat(null, destAddr + 16L, m.m01);
            UNSAFE.putFloat(null, destAddr + 20L, m.m11);
            UNSAFE.putFloat(null, destAddr + 24L, m.m21);
            UNSAFE.putFloat(null, destAddr + 28L, m.m31);
            UNSAFE.putFloat(null, destAddr + 32L, m.m02);
            UNSAFE.putFloat(null, destAddr + 36L, m.m12);
            UNSAFE.putFloat(null, destAddr + 40L, m.m22);
            UNSAFE.putFloat(null, destAddr + 44L, m.m32);
            UNSAFE.putFloat(null, destAddr + 48L, m.m03);
            UNSAFE.putFloat(null, destAddr + 52L, m.m13);
            UNSAFE.putFloat(null, destAddr + 56L, m.m23);
            UNSAFE.putFloat(null, destAddr + 60L, m.m33);
        }

        private final void put4x3Transposed(Matrix4f m, long destAddr) {
            UNSAFE.putFloat(null, destAddr, m.m00);
            UNSAFE.putFloat(null, destAddr + 4L, m.m10);
            UNSAFE.putFloat(null, destAddr + 8L, m.m20);
            UNSAFE.putFloat(null, destAddr + 12L, m.m30);
            UNSAFE.putFloat(null, destAddr + 16L, m.m01);
            UNSAFE.putFloat(null, destAddr + 20L, m.m11);
            UNSAFE.putFloat(null, destAddr + 24L, m.m21);
            UNSAFE.putFloat(null, destAddr + 28L, m.m31);
            UNSAFE.putFloat(null, destAddr + 32L, m.m02);
            UNSAFE.putFloat(null, destAddr + 36L, m.m12);
            UNSAFE.putFloat(null, destAddr + 40L, m.m22);
            UNSAFE.putFloat(null, destAddr + 44L, m.m32);
        }

        private final void putTransposed(Matrix4x3f m, long destAddr) {
            UNSAFE.putFloat(null, destAddr, m.m00);
            UNSAFE.putFloat(null, destAddr + 4L, m.m10);
            UNSAFE.putFloat(null, destAddr + 8L, m.m20);
            UNSAFE.putFloat(null, destAddr + 12L, m.m30);
            UNSAFE.putFloat(null, destAddr + 16L, m.m01);
            UNSAFE.putFloat(null, destAddr + 20L, m.m11);
            UNSAFE.putFloat(null, destAddr + 24L, m.m21);
            UNSAFE.putFloat(null, destAddr + 28L, m.m31);
            UNSAFE.putFloat(null, destAddr + 32L, m.m02);
            UNSAFE.putFloat(null, destAddr + 36L, m.m12);
            UNSAFE.putFloat(null, destAddr + 40L, m.m22);
            UNSAFE.putFloat(null, destAddr + 44L, m.m32);
        }

        private final void put(Matrix4d m, long destAddr) {
            UNSAFE.putDouble(null, destAddr, m.m00);
            UNSAFE.putDouble(null, destAddr + 8L, m.m01);
            UNSAFE.putDouble(null, destAddr + 16L, m.m02);
            UNSAFE.putDouble(null, destAddr + 24L, m.m03);
            UNSAFE.putDouble(null, destAddr + 32L, m.m10);
            UNSAFE.putDouble(null, destAddr + 40L, m.m11);
            UNSAFE.putDouble(null, destAddr + 48L, m.m12);
            UNSAFE.putDouble(null, destAddr + 56L, m.m13);
            UNSAFE.putDouble(null, destAddr + 64L, m.m20);
            UNSAFE.putDouble(null, destAddr + 72L, m.m21);
            UNSAFE.putDouble(null, destAddr + 80L, m.m22);
            UNSAFE.putDouble(null, destAddr + 88L, m.m23);
            UNSAFE.putDouble(null, destAddr + 96L, m.m30);
            UNSAFE.putDouble(null, destAddr + 104L, m.m31);
            UNSAFE.putDouble(null, destAddr + 112L, m.m32);
            UNSAFE.putDouble(null, destAddr + 120L, m.m33);
        }

        private final void put(Matrix4x3d m, long destAddr) {
            UNSAFE.putDouble(null, destAddr, m.m00);
            UNSAFE.putDouble(null, destAddr + 8L, m.m01);
            UNSAFE.putDouble(null, destAddr + 16L, m.m02);
            UNSAFE.putDouble(null, destAddr + 24L, m.m10);
            UNSAFE.putDouble(null, destAddr + 32L, m.m11);
            UNSAFE.putDouble(null, destAddr + 40L, m.m12);
            UNSAFE.putDouble(null, destAddr + 48L, m.m20);
            UNSAFE.putDouble(null, destAddr + 56L, m.m21);
            UNSAFE.putDouble(null, destAddr + 64L, m.m22);
            UNSAFE.putDouble(null, destAddr + 72L, m.m30);
            UNSAFE.putDouble(null, destAddr + 80L, m.m31);
            UNSAFE.putDouble(null, destAddr + 88L, m.m32);
        }

        private final void putTransposed(Matrix4d m, long destAddr) {
            UNSAFE.putDouble(null, destAddr, m.m00);
            UNSAFE.putDouble(null, destAddr + 8L, m.m10);
            UNSAFE.putDouble(null, destAddr + 16L, m.m20);
            UNSAFE.putDouble(null, destAddr + 24L, m.m30);
            UNSAFE.putDouble(null, destAddr + 32L, m.m01);
            UNSAFE.putDouble(null, destAddr + 40L, m.m11);
            UNSAFE.putDouble(null, destAddr + 48L, m.m21);
            UNSAFE.putDouble(null, destAddr + 56L, m.m31);
            UNSAFE.putDouble(null, destAddr + 64L, m.m02);
            UNSAFE.putDouble(null, destAddr + 72L, m.m12);
            UNSAFE.putDouble(null, destAddr + 80L, m.m22);
            UNSAFE.putDouble(null, destAddr + 88L, m.m32);
            UNSAFE.putDouble(null, destAddr + 96L, m.m03);
            UNSAFE.putDouble(null, destAddr + 104L, m.m13);
            UNSAFE.putDouble(null, destAddr + 112L, m.m23);
            UNSAFE.putDouble(null, destAddr + 120L, m.m33);
        }

        private final void putfTransposed(Matrix4d m, long destAddr) {
            UNSAFE.putFloat(null, destAddr, (float)m.m00);
            UNSAFE.putFloat(null, destAddr + 4L, (float)m.m10);
            UNSAFE.putFloat(null, destAddr + 8L, (float)m.m20);
            UNSAFE.putFloat(null, destAddr + 12L, (float)m.m30);
            UNSAFE.putFloat(null, destAddr + 16L, (float)m.m01);
            UNSAFE.putFloat(null, destAddr + 20L, (float)m.m11);
            UNSAFE.putFloat(null, destAddr + 24L, (float)m.m21);
            UNSAFE.putFloat(null, destAddr + 28L, (float)m.m31);
            UNSAFE.putFloat(null, destAddr + 32L, (float)m.m02);
            UNSAFE.putFloat(null, destAddr + 36L, (float)m.m12);
            UNSAFE.putFloat(null, destAddr + 40L, (float)m.m22);
            UNSAFE.putFloat(null, destAddr + 44L, (float)m.m32);
            UNSAFE.putFloat(null, destAddr + 48L, (float)m.m03);
            UNSAFE.putFloat(null, destAddr + 52L, (float)m.m13);
            UNSAFE.putFloat(null, destAddr + 56L, (float)m.m23);
            UNSAFE.putFloat(null, destAddr + 60L, (float)m.m33);
        }

        private final void put4x3Transposed(Matrix4d m, long destAddr) {
            UNSAFE.putDouble(null, destAddr, m.m00);
            UNSAFE.putDouble(null, destAddr + 8L, m.m10);
            UNSAFE.putDouble(null, destAddr + 16L, m.m20);
            UNSAFE.putDouble(null, destAddr + 24L, m.m30);
            UNSAFE.putDouble(null, destAddr + 32L, m.m01);
            UNSAFE.putDouble(null, destAddr + 40L, m.m11);
            UNSAFE.putDouble(null, destAddr + 48L, m.m21);
            UNSAFE.putDouble(null, destAddr + 56L, m.m31);
            UNSAFE.putDouble(null, destAddr + 64L, m.m02);
            UNSAFE.putDouble(null, destAddr + 72L, m.m12);
            UNSAFE.putDouble(null, destAddr + 80L, m.m22);
            UNSAFE.putDouble(null, destAddr + 88L, m.m32);
        }

        private final void putTransposed(Matrix4x3d m, long destAddr) {
            UNSAFE.putDouble(null, destAddr, m.m00);
            UNSAFE.putDouble(null, destAddr + 8L, m.m10);
            UNSAFE.putDouble(null, destAddr + 16L, m.m20);
            UNSAFE.putDouble(null, destAddr + 24L, m.m30);
            UNSAFE.putDouble(null, destAddr + 32L, m.m01);
            UNSAFE.putDouble(null, destAddr + 40L, m.m11);
            UNSAFE.putDouble(null, destAddr + 48L, m.m21);
            UNSAFE.putDouble(null, destAddr + 56L, m.m31);
            UNSAFE.putDouble(null, destAddr + 64L, m.m02);
            UNSAFE.putDouble(null, destAddr + 72L, m.m12);
            UNSAFE.putDouble(null, destAddr + 80L, m.m22);
            UNSAFE.putDouble(null, destAddr + 88L, m.m32);
        }

        private final void putfTransposed(Matrix4x3d m, long destAddr) {
            UNSAFE.putFloat(null, destAddr, (float)m.m00);
            UNSAFE.putFloat(null, destAddr + 4L, (float)m.m10);
            UNSAFE.putFloat(null, destAddr + 8L, (float)m.m20);
            UNSAFE.putFloat(null, destAddr + 12L, (float)m.m30);
            UNSAFE.putFloat(null, destAddr + 16L, (float)m.m01);
            UNSAFE.putFloat(null, destAddr + 20L, (float)m.m11);
            UNSAFE.putFloat(null, destAddr + 24L, (float)m.m21);
            UNSAFE.putFloat(null, destAddr + 28L, (float)m.m31);
            UNSAFE.putFloat(null, destAddr + 32L, (float)m.m02);
            UNSAFE.putFloat(null, destAddr + 36L, (float)m.m12);
            UNSAFE.putFloat(null, destAddr + 40L, (float)m.m22);
            UNSAFE.putFloat(null, destAddr + 44L, (float)m.m32);
        }

        private final void putf(Matrix4d m, long destAddr) {
            UNSAFE.putFloat(null, destAddr, (float)m.m00);
            UNSAFE.putFloat(null, destAddr + 4L, (float)m.m01);
            UNSAFE.putFloat(null, destAddr + 8L, (float)m.m02);
            UNSAFE.putFloat(null, destAddr + 12L, (float)m.m03);
            UNSAFE.putFloat(null, destAddr + 16L, (float)m.m10);
            UNSAFE.putFloat(null, destAddr + 20L, (float)m.m11);
            UNSAFE.putFloat(null, destAddr + 24L, (float)m.m12);
            UNSAFE.putFloat(null, destAddr + 28L, (float)m.m13);
            UNSAFE.putFloat(null, destAddr + 32L, (float)m.m20);
            UNSAFE.putFloat(null, destAddr + 36L, (float)m.m21);
            UNSAFE.putFloat(null, destAddr + 40L, (float)m.m22);
            UNSAFE.putFloat(null, destAddr + 44L, (float)m.m23);
            UNSAFE.putFloat(null, destAddr + 48L, (float)m.m30);
            UNSAFE.putFloat(null, destAddr + 52L, (float)m.m31);
            UNSAFE.putFloat(null, destAddr + 56L, (float)m.m32);
            UNSAFE.putFloat(null, destAddr + 60L, (float)m.m33);
        }

        private final void putf(Matrix4x3d m, long destAddr) {
            UNSAFE.putFloat(null, destAddr, (float)m.m00);
            UNSAFE.putFloat(null, destAddr + 4L, (float)m.m01);
            UNSAFE.putFloat(null, destAddr + 8L, (float)m.m02);
            UNSAFE.putFloat(null, destAddr + 12L, (float)m.m10);
            UNSAFE.putFloat(null, destAddr + 16L, (float)m.m11);
            UNSAFE.putFloat(null, destAddr + 20L, (float)m.m12);
            UNSAFE.putFloat(null, destAddr + 24L, (float)m.m20);
            UNSAFE.putFloat(null, destAddr + 28L, (float)m.m21);
            UNSAFE.putFloat(null, destAddr + 32L, (float)m.m22);
            UNSAFE.putFloat(null, destAddr + 36L, (float)m.m30);
            UNSAFE.putFloat(null, destAddr + 40L, (float)m.m31);
            UNSAFE.putFloat(null, destAddr + 44L, (float)m.m32);
        }

        private final void put(Matrix3f m, long destAddr) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(null, destAddr + (long)(i << 3), UNSAFE.getLong(m, Matrix3f_m00 + (long)(i << 3)));
            }
            UNSAFE.putFloat(null, destAddr + 32L, m.m22);
        }

        private final void put(Matrix3d m, long destAddr) {
            UNSAFE.putDouble(null, destAddr, m.m00);
            UNSAFE.putDouble(null, destAddr + 8L, m.m01);
            UNSAFE.putDouble(null, destAddr + 16L, m.m02);
            UNSAFE.putDouble(null, destAddr + 24L, m.m10);
            UNSAFE.putDouble(null, destAddr + 32L, m.m11);
            UNSAFE.putDouble(null, destAddr + 40L, m.m12);
            UNSAFE.putDouble(null, destAddr + 48L, m.m20);
            UNSAFE.putDouble(null, destAddr + 56L, m.m21);
            UNSAFE.putDouble(null, destAddr + 64L, m.m22);
        }

        private final void putf(Matrix3d m, long destAddr) {
            UNSAFE.putFloat(null, destAddr, (float)m.m00);
            UNSAFE.putFloat(null, destAddr + 4L, (float)m.m01);
            UNSAFE.putFloat(null, destAddr + 8L, (float)m.m02);
            UNSAFE.putFloat(null, destAddr + 12L, (float)m.m10);
            UNSAFE.putFloat(null, destAddr + 16L, (float)m.m11);
            UNSAFE.putFloat(null, destAddr + 20L, (float)m.m12);
            UNSAFE.putFloat(null, destAddr + 24L, (float)m.m20);
            UNSAFE.putFloat(null, destAddr + 28L, (float)m.m21);
            UNSAFE.putFloat(null, destAddr + 32L, (float)m.m22);
        }

        private final void get(Matrix4f m, long srcAddr) {
            for (int i = 0; i < 8; ++i) {
                UNSAFE.putOrderedLong(m, Matrix4f_m00 + (long)(i << 3), UNSAFE.getLong(srcAddr + (long)(i << 3)));
            }
        }

        private final void get(Matrix4x3f m, long srcAddr) {
            for (int i = 0; i < 6; ++i) {
                UNSAFE.putOrderedLong(m, Matrix4x3f_m00 + (long)(i << 3), UNSAFE.getLong(srcAddr + (long)(i << 3)));
            }
        }

        private final void get(Matrix4d m, long srcAddr) {
            m.m00 = UNSAFE.getDouble(null, srcAddr);
            m.m01 = UNSAFE.getDouble(null, srcAddr + 8L);
            m.m02 = UNSAFE.getDouble(null, srcAddr + 16L);
            m.m03 = UNSAFE.getDouble(null, srcAddr + 24L);
            m.m10 = UNSAFE.getDouble(null, srcAddr + 32L);
            m.m11 = UNSAFE.getDouble(null, srcAddr + 40L);
            m.m12 = UNSAFE.getDouble(null, srcAddr + 48L);
            m.m13 = UNSAFE.getDouble(null, srcAddr + 56L);
            m.m20 = UNSAFE.getDouble(null, srcAddr + 64L);
            m.m21 = UNSAFE.getDouble(null, srcAddr + 72L);
            m.m22 = UNSAFE.getDouble(null, srcAddr + 80L);
            m.m23 = UNSAFE.getDouble(null, srcAddr + 88L);
            m.m30 = UNSAFE.getDouble(null, srcAddr + 96L);
            m.m31 = UNSAFE.getDouble(null, srcAddr + 104L);
            m.m32 = UNSAFE.getDouble(null, srcAddr + 112L);
            m.m33 = UNSAFE.getDouble(null, srcAddr + 120L);
        }

        private final void get(Matrix4x3d m, long srcAddr) {
            m.m00 = UNSAFE.getDouble(null, srcAddr);
            m.m01 = UNSAFE.getDouble(null, srcAddr + 8L);
            m.m02 = UNSAFE.getDouble(null, srcAddr + 16L);
            m.m10 = UNSAFE.getDouble(null, srcAddr + 24L);
            m.m11 = UNSAFE.getDouble(null, srcAddr + 32L);
            m.m12 = UNSAFE.getDouble(null, srcAddr + 40L);
            m.m20 = UNSAFE.getDouble(null, srcAddr + 48L);
            m.m21 = UNSAFE.getDouble(null, srcAddr + 56L);
            m.m22 = UNSAFE.getDouble(null, srcAddr + 64L);
            m.m30 = UNSAFE.getDouble(null, srcAddr + 72L);
            m.m31 = UNSAFE.getDouble(null, srcAddr + 80L);
            m.m32 = UNSAFE.getDouble(null, srcAddr + 88L);
        }

        private final void getf(Matrix4d m, long srcAddr) {
            m.m00 = UNSAFE.getFloat(null, srcAddr);
            m.m01 = UNSAFE.getFloat(null, srcAddr + 4L);
            m.m02 = UNSAFE.getFloat(null, srcAddr + 8L);
            m.m03 = UNSAFE.getFloat(null, srcAddr + 12L);
            m.m10 = UNSAFE.getFloat(null, srcAddr + 16L);
            m.m11 = UNSAFE.getFloat(null, srcAddr + 20L);
            m.m12 = UNSAFE.getFloat(null, srcAddr + 24L);
            m.m13 = UNSAFE.getFloat(null, srcAddr + 28L);
            m.m20 = UNSAFE.getFloat(null, srcAddr + 32L);
            m.m21 = UNSAFE.getFloat(null, srcAddr + 36L);
            m.m22 = UNSAFE.getFloat(null, srcAddr + 40L);
            m.m23 = UNSAFE.getFloat(null, srcAddr + 44L);
            m.m30 = UNSAFE.getFloat(null, srcAddr + 48L);
            m.m31 = UNSAFE.getFloat(null, srcAddr + 52L);
            m.m32 = UNSAFE.getFloat(null, srcAddr + 56L);
            m.m33 = UNSAFE.getFloat(null, srcAddr + 60L);
        }

        private final void getf(Matrix4x3d m, long srcAddr) {
            m.m00 = UNSAFE.getFloat(null, srcAddr);
            m.m01 = UNSAFE.getFloat(null, srcAddr + 4L);
            m.m02 = UNSAFE.getFloat(null, srcAddr + 8L);
            m.m10 = UNSAFE.getFloat(null, srcAddr + 12L);
            m.m11 = UNSAFE.getFloat(null, srcAddr + 16L);
            m.m12 = UNSAFE.getFloat(null, srcAddr + 20L);
            m.m20 = UNSAFE.getFloat(null, srcAddr + 24L);
            m.m21 = UNSAFE.getFloat(null, srcAddr + 28L);
            m.m22 = UNSAFE.getFloat(null, srcAddr + 32L);
            m.m30 = UNSAFE.getFloat(null, srcAddr + 36L);
            m.m31 = UNSAFE.getFloat(null, srcAddr + 40L);
            m.m32 = UNSAFE.getFloat(null, srcAddr + 44L);
        }

        private final void get(Matrix3f m, long srcAddr) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(m, Matrix3f_m00 + (long)(i << 3), UNSAFE.getLong(null, srcAddr + (long)(i << 3)));
            }
            m.m22 = UNSAFE.getFloat(null, srcAddr + 32L);
        }

        private final void get(Matrix3d m, long srcAddr) {
            m.m00 = UNSAFE.getDouble(null, srcAddr);
            m.m01 = UNSAFE.getDouble(null, srcAddr + 8L);
            m.m02 = UNSAFE.getDouble(null, srcAddr + 16L);
            m.m10 = UNSAFE.getDouble(null, srcAddr + 24L);
            m.m11 = UNSAFE.getDouble(null, srcAddr + 32L);
            m.m12 = UNSAFE.getDouble(null, srcAddr + 40L);
            m.m20 = UNSAFE.getDouble(null, srcAddr + 48L);
            m.m21 = UNSAFE.getDouble(null, srcAddr + 56L);
            m.m22 = UNSAFE.getDouble(null, srcAddr + 64L);
        }

        private final void getf(Matrix3d m, long srcAddr) {
            m.m00 = UNSAFE.getFloat(null, srcAddr);
            m.m01 = UNSAFE.getFloat(null, srcAddr + 4L);
            m.m02 = UNSAFE.getFloat(null, srcAddr + 8L);
            m.m10 = UNSAFE.getFloat(null, srcAddr + 12L);
            m.m11 = UNSAFE.getFloat(null, srcAddr + 16L);
            m.m12 = UNSAFE.getFloat(null, srcAddr + 20L);
            m.m20 = UNSAFE.getFloat(null, srcAddr + 24L);
            m.m21 = UNSAFE.getFloat(null, srcAddr + 28L);
            m.m22 = UNSAFE.getFloat(null, srcAddr + 32L);
        }

        final void copy(Matrix4f src, Matrix4f dest) {
            for (int i = 0; i < 8; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4f_m00 + (long)(i << 3), UNSAFE.getLong(src, Matrix4f_m00 + (long)(i << 3)));
            }
        }

        final void copy(Matrix3f src, Matrix4f dest) {
            for (int i = 0; i < 3; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4f_m00 + (long)(i << 4), UNSAFE.getLong(src, Matrix3f_m00 + (long)(12 * i)));
                long lng = (long)UNSAFE.getInt(src, Matrix3f_m00 + 8L + (long)(12 * i)) & 0xFFFFFFFFL;
                UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 8L + (long)(i << 4), lng);
            }
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 48L, 0L);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 56L, 4575657221408423936L);
        }

        final void copy(Matrix4f src, Matrix3f dest) {
            for (int i = 0; i < 3; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix3f_m00 + (long)(12 * i), UNSAFE.getLong(src, Matrix4f_m00 + (long)(i << 4)));
            }
            dest.m02 = src.m02;
            dest.m12 = src.m12;
            dest.m22 = src.m22;
        }

        final void copy(Matrix3f src, Matrix4x3f dest) {
            for (int i = 0; i < 3; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + (long)(12 * i), UNSAFE.getLong(src, Matrix3f_m00 + (long)(12 * i)));
            }
            UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + 36L, 0L);
            dest.m02 = src.m02;
            dest.m12 = src.m12;
            dest.m22 = src.m22;
            dest.m32 = 0.0f;
        }

        final void copy3x3(Matrix4f src, Matrix4f dest) {
            for (int i = 0; i < 3; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4f_m00 + (long)(i << 4), UNSAFE.getLong(src, Matrix4f_m00 + (long)(i << 4)));
            }
            dest.m02 = src.m02;
            dest.m12 = src.m12;
            dest.m22 = src.m22;
        }

        final void copy4x3(Matrix4x3f src, Matrix4f dest) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4f_m00 + (long)(i << 4), UNSAFE.getLong(src, Matrix4x3f_m00 + (long)(12 * i)));
            }
            dest.m02 = src.m02;
            dest.m12 = src.m12;
            dest.m22 = src.m22;
            dest.m32 = src.m32;
        }

        final void copy4x3(Matrix4f src, Matrix4f dest) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4f_m00 + (long)(i << 4), UNSAFE.getLong(src, Matrix4f_m00 + (long)(i << 4)));
            }
            dest.m02 = src.m02;
            dest.m12 = src.m12;
            dest.m22 = src.m22;
            dest.m32 = src.m32;
        }

        final void copy(Matrix4f src, Matrix4x3f dest) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + (long)(12 * i), UNSAFE.getLong(src, Matrix4f_m00 + (long)(i << 4)));
            }
            dest.m02 = src.m02;
            dest.m12 = src.m12;
            dest.m22 = src.m22;
            dest.m32 = src.m32;
        }

        final void copy(Matrix4x3f src, Matrix4x3f dest) {
            for (int i = 0; i < 6; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + (long)(i << 3), UNSAFE.getLong(src, Matrix4x3f_m00 + (long)(i << 3)));
            }
        }

        final void copy(Matrix3f src, Matrix3f dest) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix3f_m00 + (long)(i << 3), UNSAFE.getLong(src, Matrix3f_m00 + (long)(i << 3)));
            }
            dest.m22 = src.m22;
        }

        final void identity(Matrix4f dest) {
            UNSAFE.putOrderedLong(dest, Matrix4f_m00, 1065353216L);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 8L, 0L);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 16L, 4575657221408423936L);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 24L, 0L);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 32L, 0L);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 40L, 1065353216L);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 48L, 0L);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 56L, 4575657221408423936L);
        }

        final void identity(Matrix4x3f dest) {
            UNSAFE.putOrderedLong(dest, Matrix4x3f_m00, 1065353216L);
            UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + 8L, 0L);
            UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + 16L, 1065353216L);
            UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + 24L, 0L);
            UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + 32L, 1065353216L);
            UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + 40L, 0L);
        }

        final void identity(Matrix3f dest) {
            UNSAFE.putOrderedLong(dest, Matrix3f_m00, 1065353216L);
            UNSAFE.putOrderedLong(dest, Matrix3f_m00 + 8L, 0L);
            UNSAFE.putOrderedLong(dest, Matrix3f_m00 + 16L, 1065353216L);
            UNSAFE.putOrderedLong(dest, Matrix3f_m00 + 24L, 0L);
            dest.m22 = 1.0f;
        }

        final void swap(Matrix4f m1, Matrix4f m2) {
            for (int i = 0; i < 8; ++i) {
                long tmp = UNSAFE.getLong(m1, Matrix4f_m00 + (long)(i << 3));
                UNSAFE.putOrderedLong(m1, Matrix4f_m00 + (long)(i << 3), UNSAFE.getLong(m2, Matrix4f_m00 + (long)(i << 3)));
                UNSAFE.putOrderedLong(m2, Matrix4f_m00 + (long)(i << 3), tmp);
            }
        }

        final void swap(Matrix4x3f m1, Matrix4x3f m2) {
            for (int i = 0; i < 6; ++i) {
                long tmp = UNSAFE.getLong(m1, Matrix4x3f_m00 + (long)(i << 3));
                UNSAFE.putOrderedLong(m1, Matrix4x3f_m00 + (long)(i << 3), UNSAFE.getLong(m2, Matrix4x3f_m00 + (long)(i << 3)));
                UNSAFE.putOrderedLong(m2, Matrix4x3f_m00 + (long)(i << 3), tmp);
            }
        }

        final void swap(Matrix3f m1, Matrix3f m2) {
            for (int i = 0; i < 4; ++i) {
                long tmp = UNSAFE.getLong(m1, Matrix3f_m00 + (long)(i << 3));
                UNSAFE.putOrderedLong(m1, Matrix3f_m00 + (long)(i << 3), UNSAFE.getLong(m2, Matrix3f_m00 + (long)(i << 3)));
                UNSAFE.putOrderedLong(m2, Matrix3f_m00 + (long)(i << 3), tmp);
            }
            float tmp2 = m1.m22;
            m1.m22 = m2.m22;
            m2.m22 = tmp2;
        }

        final void zero(Matrix4f dest) {
            for (int i = 0; i < 8; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4f_m00 + (long)(i << 3), 0L);
            }
        }

        final void zero(Matrix4x3f dest) {
            for (int i = 0; i < 6; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + (long)(i << 3), 0L);
            }
        }

        final void zero(Matrix3f dest) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix3f_m00 + (long)(i << 3), 0L);
            }
            dest.m22 = 0.0f;
        }

        private void putMatrix3f(Quaternionf q, long addr) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            UNSAFE.putFloat(null, addr, 1.0f - q11 - q22);
            UNSAFE.putFloat(null, addr + 4L, q01 + q23);
            UNSAFE.putFloat(null, addr + 8L, q02 - q13);
            UNSAFE.putFloat(null, addr + 12L, q01 - q23);
            UNSAFE.putFloat(null, addr + 16L, 1.0f - q22 - q00);
            UNSAFE.putFloat(null, addr + 20L, q12 + q03);
            UNSAFE.putFloat(null, addr + 24L, q02 + q13);
            UNSAFE.putFloat(null, addr + 28L, q12 - q03);
            UNSAFE.putFloat(null, addr + 32L, 1.0f - q11 - q00);
        }

        private void putMatrix4f(Quaternionf q, long addr) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            UNSAFE.putFloat(null, addr, 1.0f - q11 - q22);
            UNSAFE.putFloat(null, addr + 4L, q01 + q23);
            UNSAFE.putFloat(null, addr + 8L, q02 - q13);
            UNSAFE.putFloat(null, addr + 12L, 0.0f);
            UNSAFE.putFloat(null, addr + 16L, q01 - q23);
            UNSAFE.putFloat(null, addr + 20L, 1.0f - q22 - q00);
            UNSAFE.putFloat(null, addr + 24L, q12 + q03);
            UNSAFE.putFloat(null, addr + 28L, 0.0f);
            UNSAFE.putFloat(null, addr + 32L, q02 + q13);
            UNSAFE.putFloat(null, addr + 36L, q12 - q03);
            UNSAFE.putFloat(null, addr + 40L, 1.0f - q11 - q00);
            UNSAFE.putFloat(null, addr + 44L, 0.0f);
            UNSAFE.putOrderedLong(null, addr + 48L, 0L);
            UNSAFE.putOrderedLong(null, addr + 56L, 4575657221408423936L);
        }

        private void putMatrix4x3f(Quaternionf q, long addr) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            UNSAFE.putFloat(null, addr, 1.0f - q11 - q22);
            UNSAFE.putFloat(null, addr + 4L, q01 + q23);
            UNSAFE.putFloat(null, addr + 8L, q02 - q13);
            UNSAFE.putFloat(null, addr + 12L, q01 - q23);
            UNSAFE.putFloat(null, addr + 16L, 1.0f - q22 - q00);
            UNSAFE.putFloat(null, addr + 20L, q12 + q03);
            UNSAFE.putFloat(null, addr + 24L, q02 + q13);
            UNSAFE.putFloat(null, addr + 28L, q12 - q03);
            UNSAFE.putFloat(null, addr + 32L, 1.0f - q11 - q00);
            UNSAFE.putOrderedLong(null, addr + 36L, 0L);
            UNSAFE.putFloat(null, addr + 44L, 0.0f);
        }

        final void putMatrix3f(Quaternionf q, int position, ByteBuffer dest) {
            long addr = this.addressOf(dest) + (long)position;
            this.putMatrix3f(q, addr);
        }

        final void putMatrix3f(Quaternionf q, int position, FloatBuffer dest) {
            long addr = this.addressOf(dest) + (long)(position << 2);
            this.putMatrix3f(q, addr);
        }

        final void putMatrix4f(Quaternionf q, int position, ByteBuffer dest) {
            long addr = this.addressOf(dest) + (long)position;
            this.putMatrix4f(q, addr);
        }

        final void putMatrix4f(Quaternionf q, int position, FloatBuffer dest) {
            long addr = this.addressOf(dest) + (long)(position << 2);
            this.putMatrix4f(q, addr);
        }

        final void putMatrix4x3f(Quaternionf q, int position, ByteBuffer dest) {
            long addr = this.addressOf(dest) + (long)position;
            this.putMatrix4x3f(q, addr);
        }

        final void putMatrix4x3f(Quaternionf q, int position, FloatBuffer dest) {
            long addr = this.addressOf(dest) + (long)(position << 2);
            this.putMatrix4x3f(q, addr);
        }

        final void put(Matrix4f m, int offset, FloatBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 2));
        }

        final void put(Matrix4f m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        final void put(Matrix4x3f m, int offset, FloatBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 2));
        }

        final void put(Matrix4x3f m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        final void put4x4(Matrix4x3f m, int offset, FloatBuffer dest) {
            this.put4x4(m, this.addressOf(dest) + (long)(offset << 2));
        }

        final void put4x4(Matrix4x3f m, int offset, ByteBuffer dest) {
            this.put4x4(m, this.addressOf(dest) + (long)offset);
        }

        final void putTransposed(Matrix4f m, int offset, FloatBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)(offset << 2));
        }

        final void putTransposed(Matrix4f m, int offset, ByteBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)offset);
        }

        final void put4x3Transposed(Matrix4f m, int offset, FloatBuffer dest) {
            this.put4x3Transposed(m, this.addressOf(dest) + (long)(offset << 2));
        }

        final void put4x3Transposed(Matrix4f m, int offset, ByteBuffer dest) {
            this.put4x3Transposed(m, this.addressOf(dest) + (long)offset);
        }

        final void putTransposed(Matrix4x3f m, int offset, FloatBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)(offset << 2));
        }

        final void putTransposed(Matrix4x3f m, int offset, ByteBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)offset);
        }

        final void put(Matrix4d m, int offset, DoubleBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 3));
        }

        final void put(Matrix4d m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        final void put(Matrix4x3d m, int offset, DoubleBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 3));
        }

        final void put(Matrix4x3d m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        final void putf(Matrix4d m, int offset, FloatBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)(offset << 2));
        }

        final void putf(Matrix4d m, int offset, ByteBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)offset);
        }

        final void putf(Matrix4x3d m, int offset, FloatBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)(offset << 2));
        }

        final void putf(Matrix4x3d m, int offset, ByteBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)offset);
        }

        final void putTransposed(Matrix4d m, int offset, DoubleBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)(offset << 3));
        }

        final void putTransposed(Matrix4d m, int offset, ByteBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)offset);
        }

        final void put4x3Transposed(Matrix4d m, int offset, DoubleBuffer dest) {
            this.put4x3Transposed(m, this.addressOf(dest) + (long)(offset << 3));
        }

        final void put4x3Transposed(Matrix4d m, int offset, ByteBuffer dest) {
            this.put4x3Transposed(m, this.addressOf(dest) + (long)offset);
        }

        final void putTransposed(Matrix4x3d m, int offset, DoubleBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)(offset << 3));
        }

        final void putTransposed(Matrix4x3d m, int offset, ByteBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)offset);
        }

        final void putfTransposed(Matrix4d m, int offset, FloatBuffer dest) {
            this.putfTransposed(m, this.addressOf(dest) + (long)(offset << 2));
        }

        final void putfTransposed(Matrix4d m, int offset, ByteBuffer dest) {
            this.putfTransposed(m, this.addressOf(dest) + (long)offset);
        }

        final void putfTransposed(Matrix4x3d m, int offset, FloatBuffer dest) {
            this.putfTransposed(m, this.addressOf(dest) + (long)(offset << 2));
        }

        final void putfTransposed(Matrix4x3d m, int offset, ByteBuffer dest) {
            this.putfTransposed(m, this.addressOf(dest) + (long)offset);
        }

        final void put(Matrix3f m, int offset, FloatBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 2));
        }

        final void put(Matrix3f m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        final void put(Matrix3d m, int offset, DoubleBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 3));
        }

        final void put(Matrix3d m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        final void putf(Matrix3d m, int offset, FloatBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)(offset << 2));
        }

        final void putf(Matrix3d m, int offset, ByteBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)offset);
        }

        final void get(Matrix4f m, int offset, FloatBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 2));
        }

        final void get(Matrix4f m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        final void get(Matrix4x3f m, int offset, FloatBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 2));
        }

        final void get(Matrix4x3f m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        final void get(Matrix4d m, int offset, DoubleBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 3));
        }

        final void get(Matrix4d m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        final void get(Matrix4x3d m, int offset, DoubleBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 3));
        }

        final void get(Matrix4x3d m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        final void getf(Matrix4d m, int offset, FloatBuffer src) {
            this.getf(m, this.addressOf(src) + (long)(offset << 2));
        }

        final void getf(Matrix4d m, int offset, ByteBuffer src) {
            this.getf(m, this.addressOf(src) + (long)offset);
        }

        final void getf(Matrix4x3d m, int offset, FloatBuffer src) {
            this.getf(m, this.addressOf(src) + (long)(offset << 2));
        }

        final void getf(Matrix4x3d m, int offset, ByteBuffer src) {
            this.getf(m, this.addressOf(src) + (long)offset);
        }

        final void get(Matrix3f m, int offset, FloatBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 2));
        }

        final void get(Matrix3f m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        final void get(Matrix3d m, int offset, DoubleBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 3));
        }

        final void get(Matrix3d m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        final void getf(Matrix3d m, int offset, FloatBuffer src) {
            this.getf(m, this.addressOf(src) + (long)(offset << 2));
        }

        final void getf(Matrix3d m, int offset, ByteBuffer src) {
            this.getf(m, this.addressOf(src) + (long)offset);
        }

        static {
            try {
                ADDRESS = UNSAFE.objectFieldOffset(MemUtilUnsafe.getDeclaredField(class$java$nio$Buffer == null ? (class$java$nio$Buffer = MemUtil.class$("java.nio.Buffer")) : class$java$nio$Buffer, "address"));
                Matrix4f_m00 = MemUtilUnsafe.checkMatrix4f();
                Matrix4x3f_m00 = MemUtilUnsafe.checkMatrix4x3f();
                Matrix3f_m00 = MemUtilUnsafe.checkMatrix3f();
                (class$sun$misc$Unsafe == null ? (class$sun$misc$Unsafe = MemUtil.class$("sun.misc.Unsafe")) : class$sun$misc$Unsafe).getDeclaredMethod("getLong", class$java$lang$Object == null ? (class$java$lang$Object = MemUtil.class$("java.lang.Object")) : class$java$lang$Object, Long.TYPE);
                (class$sun$misc$Unsafe == null ? (class$sun$misc$Unsafe = MemUtil.class$("sun.misc.Unsafe")) : class$sun$misc$Unsafe).getDeclaredMethod("putOrderedLong", class$java$lang$Object == null ? (class$java$lang$Object = MemUtil.class$("java.lang.Object")) : class$java$lang$Object, Long.TYPE, Long.TYPE);
            }
            catch (NoSuchFieldException e) {
                throw new UnsupportedOperationException();
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException();
            }
        }
    }

    static final class MemUtilNIO
    extends MemUtil {
        MemUtilNIO() {
        }

        final void put(Matrix4f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m01);
            dest.put(offset + 2, m.m02);
            dest.put(offset + 3, m.m03);
            dest.put(offset + 4, m.m10);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m12);
            dest.put(offset + 7, m.m13);
            dest.put(offset + 8, m.m20);
            dest.put(offset + 9, m.m21);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, m.m23);
            dest.put(offset + 12, m.m30);
            dest.put(offset + 13, m.m31);
            dest.put(offset + 14, m.m32);
            dest.put(offset + 15, m.m33);
        }

        final void put(Matrix4f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00);
            dest.putFloat(offset + 4, m.m01);
            dest.putFloat(offset + 8, m.m02);
            dest.putFloat(offset + 12, m.m03);
            dest.putFloat(offset + 16, m.m10);
            dest.putFloat(offset + 20, m.m11);
            dest.putFloat(offset + 24, m.m12);
            dest.putFloat(offset + 28, m.m13);
            dest.putFloat(offset + 32, m.m20);
            dest.putFloat(offset + 36, m.m21);
            dest.putFloat(offset + 40, m.m22);
            dest.putFloat(offset + 44, m.m23);
            dest.putFloat(offset + 48, m.m30);
            dest.putFloat(offset + 52, m.m31);
            dest.putFloat(offset + 56, m.m32);
            dest.putFloat(offset + 60, m.m33);
        }

        final void put(Matrix4x3f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m01);
            dest.put(offset + 2, m.m02);
            dest.put(offset + 3, m.m10);
            dest.put(offset + 4, m.m11);
            dest.put(offset + 5, m.m12);
            dest.put(offset + 6, m.m20);
            dest.put(offset + 7, m.m21);
            dest.put(offset + 8, m.m22);
            dest.put(offset + 9, m.m30);
            dest.put(offset + 10, m.m31);
            dest.put(offset + 11, m.m32);
        }

        final void put(Matrix4x3f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00);
            dest.putFloat(offset + 4, m.m01);
            dest.putFloat(offset + 8, m.m02);
            dest.putFloat(offset + 12, m.m10);
            dest.putFloat(offset + 16, m.m11);
            dest.putFloat(offset + 20, m.m12);
            dest.putFloat(offset + 24, m.m20);
            dest.putFloat(offset + 28, m.m21);
            dest.putFloat(offset + 32, m.m22);
            dest.putFloat(offset + 36, m.m30);
            dest.putFloat(offset + 40, m.m31);
            dest.putFloat(offset + 44, m.m32);
        }

        final void put4x4(Matrix4x3f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m01);
            dest.put(offset + 2, m.m02);
            dest.put(offset + 3, 0.0f);
            dest.put(offset + 4, m.m10);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m12);
            dest.put(offset + 7, 0.0f);
            dest.put(offset + 8, m.m20);
            dest.put(offset + 9, m.m21);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, 0.0f);
            dest.put(offset + 12, m.m30);
            dest.put(offset + 13, m.m31);
            dest.put(offset + 14, m.m32);
            dest.put(offset + 15, 1.0f);
        }

        final void put4x4(Matrix4x3f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00);
            dest.putFloat(offset + 4, m.m01);
            dest.putFloat(offset + 8, m.m02);
            dest.putFloat(offset + 12, 0.0f);
            dest.putFloat(offset + 16, m.m10);
            dest.putFloat(offset + 20, m.m11);
            dest.putFloat(offset + 24, m.m12);
            dest.putFloat(offset + 28, 0.0f);
            dest.putFloat(offset + 32, m.m20);
            dest.putFloat(offset + 36, m.m21);
            dest.putFloat(offset + 40, m.m22);
            dest.putFloat(offset + 44, 0.0f);
            dest.putFloat(offset + 48, m.m30);
            dest.putFloat(offset + 52, m.m31);
            dest.putFloat(offset + 56, m.m32);
            dest.putFloat(offset + 60, 1.0f);
        }

        final void putTransposed(Matrix4f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m10);
            dest.put(offset + 2, m.m20);
            dest.put(offset + 3, m.m30);
            dest.put(offset + 4, m.m01);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m21);
            dest.put(offset + 7, m.m31);
            dest.put(offset + 8, m.m02);
            dest.put(offset + 9, m.m12);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, m.m32);
            dest.put(offset + 12, m.m03);
            dest.put(offset + 13, m.m13);
            dest.put(offset + 14, m.m23);
            dest.put(offset + 15, m.m33);
        }

        final void putTransposed(Matrix4f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00);
            dest.putFloat(offset + 4, m.m10);
            dest.putFloat(offset + 8, m.m20);
            dest.putFloat(offset + 12, m.m30);
            dest.putFloat(offset + 16, m.m01);
            dest.putFloat(offset + 20, m.m11);
            dest.putFloat(offset + 24, m.m21);
            dest.putFloat(offset + 28, m.m31);
            dest.putFloat(offset + 32, m.m02);
            dest.putFloat(offset + 36, m.m12);
            dest.putFloat(offset + 40, m.m22);
            dest.putFloat(offset + 44, m.m32);
            dest.putFloat(offset + 48, m.m03);
            dest.putFloat(offset + 52, m.m13);
            dest.putFloat(offset + 56, m.m23);
            dest.putFloat(offset + 60, m.m33);
        }

        final void put4x3Transposed(Matrix4f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m10);
            dest.put(offset + 2, m.m20);
            dest.put(offset + 3, m.m30);
            dest.put(offset + 4, m.m01);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m21);
            dest.put(offset + 7, m.m31);
            dest.put(offset + 8, m.m02);
            dest.put(offset + 9, m.m12);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, m.m32);
        }

        final void put4x3Transposed(Matrix4f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00);
            dest.putFloat(offset + 4, m.m10);
            dest.putFloat(offset + 8, m.m20);
            dest.putFloat(offset + 12, m.m30);
            dest.putFloat(offset + 16, m.m01);
            dest.putFloat(offset + 20, m.m11);
            dest.putFloat(offset + 24, m.m21);
            dest.putFloat(offset + 28, m.m31);
            dest.putFloat(offset + 32, m.m02);
            dest.putFloat(offset + 36, m.m12);
            dest.putFloat(offset + 40, m.m22);
            dest.putFloat(offset + 44, m.m32);
        }

        final void putTransposed(Matrix4x3f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m10);
            dest.put(offset + 2, m.m20);
            dest.put(offset + 3, m.m30);
            dest.put(offset + 4, m.m01);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m21);
            dest.put(offset + 7, m.m31);
            dest.put(offset + 8, m.m02);
            dest.put(offset + 9, m.m12);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, m.m32);
        }

        final void putTransposed(Matrix4x3f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00);
            dest.putFloat(offset + 4, m.m10);
            dest.putFloat(offset + 8, m.m20);
            dest.putFloat(offset + 12, m.m30);
            dest.putFloat(offset + 16, m.m01);
            dest.putFloat(offset + 20, m.m11);
            dest.putFloat(offset + 24, m.m21);
            dest.putFloat(offset + 28, m.m31);
            dest.putFloat(offset + 32, m.m02);
            dest.putFloat(offset + 36, m.m12);
            dest.putFloat(offset + 40, m.m22);
            dest.putFloat(offset + 44, m.m32);
        }

        final void put(Matrix4d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m01);
            dest.put(offset + 2, m.m02);
            dest.put(offset + 3, m.m03);
            dest.put(offset + 4, m.m10);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m12);
            dest.put(offset + 7, m.m13);
            dest.put(offset + 8, m.m20);
            dest.put(offset + 9, m.m21);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, m.m23);
            dest.put(offset + 12, m.m30);
            dest.put(offset + 13, m.m31);
            dest.put(offset + 14, m.m32);
            dest.put(offset + 15, m.m33);
        }

        final void put(Matrix4d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00);
            dest.putDouble(offset + 4, m.m01);
            dest.putDouble(offset + 8, m.m02);
            dest.putDouble(offset + 12, m.m03);
            dest.putDouble(offset + 16, m.m10);
            dest.putDouble(offset + 20, m.m11);
            dest.putDouble(offset + 24, m.m12);
            dest.putDouble(offset + 28, m.m13);
            dest.putDouble(offset + 32, m.m20);
            dest.putDouble(offset + 36, m.m21);
            dest.putDouble(offset + 40, m.m22);
            dest.putDouble(offset + 44, m.m23);
            dest.putDouble(offset + 48, m.m30);
            dest.putDouble(offset + 52, m.m31);
            dest.putDouble(offset + 56, m.m32);
            dest.putDouble(offset + 60, m.m33);
        }

        final void put(Matrix4x3d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m01);
            dest.put(offset + 2, m.m02);
            dest.put(offset + 3, m.m10);
            dest.put(offset + 4, m.m11);
            dest.put(offset + 5, m.m12);
            dest.put(offset + 6, m.m20);
            dest.put(offset + 7, m.m21);
            dest.put(offset + 8, m.m22);
            dest.put(offset + 9, m.m30);
            dest.put(offset + 10, m.m31);
            dest.put(offset + 11, m.m32);
        }

        final void put(Matrix4x3d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00);
            dest.putDouble(offset + 4, m.m01);
            dest.putDouble(offset + 8, m.m02);
            dest.putDouble(offset + 12, m.m10);
            dest.putDouble(offset + 16, m.m11);
            dest.putDouble(offset + 20, m.m12);
            dest.putDouble(offset + 24, m.m20);
            dest.putDouble(offset + 28, m.m21);
            dest.putDouble(offset + 32, m.m22);
            dest.putDouble(offset + 36, m.m30);
            dest.putDouble(offset + 40, m.m31);
            dest.putDouble(offset + 44, m.m32);
        }

        final void putf(Matrix4d m, int offset, FloatBuffer dest) {
            dest.put(offset, (float)m.m00);
            dest.put(offset + 1, (float)m.m01);
            dest.put(offset + 2, (float)m.m02);
            dest.put(offset + 3, (float)m.m03);
            dest.put(offset + 4, (float)m.m10);
            dest.put(offset + 5, (float)m.m11);
            dest.put(offset + 6, (float)m.m12);
            dest.put(offset + 7, (float)m.m13);
            dest.put(offset + 8, (float)m.m20);
            dest.put(offset + 9, (float)m.m21);
            dest.put(offset + 10, (float)m.m22);
            dest.put(offset + 11, (float)m.m23);
            dest.put(offset + 12, (float)m.m30);
            dest.put(offset + 13, (float)m.m31);
            dest.put(offset + 14, (float)m.m32);
            dest.put(offset + 15, (float)m.m33);
        }

        final void putf(Matrix4d m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, (float)m.m00);
            dest.putFloat(offset + 4, (float)m.m01);
            dest.putFloat(offset + 8, (float)m.m02);
            dest.putFloat(offset + 12, (float)m.m03);
            dest.putFloat(offset + 16, (float)m.m10);
            dest.putFloat(offset + 20, (float)m.m11);
            dest.putFloat(offset + 24, (float)m.m12);
            dest.putFloat(offset + 28, (float)m.m13);
            dest.putFloat(offset + 32, (float)m.m20);
            dest.putFloat(offset + 36, (float)m.m21);
            dest.putFloat(offset + 40, (float)m.m22);
            dest.putFloat(offset + 44, (float)m.m23);
            dest.putFloat(offset + 48, (float)m.m30);
            dest.putFloat(offset + 52, (float)m.m31);
            dest.putFloat(offset + 56, (float)m.m32);
            dest.putFloat(offset + 60, (float)m.m33);
        }

        final void putf(Matrix4x3d m, int offset, FloatBuffer dest) {
            dest.put(offset, (float)m.m00);
            dest.put(offset + 1, (float)m.m01);
            dest.put(offset + 2, (float)m.m02);
            dest.put(offset + 3, (float)m.m10);
            dest.put(offset + 4, (float)m.m11);
            dest.put(offset + 5, (float)m.m12);
            dest.put(offset + 6, (float)m.m20);
            dest.put(offset + 7, (float)m.m21);
            dest.put(offset + 8, (float)m.m22);
            dest.put(offset + 9, (float)m.m30);
            dest.put(offset + 10, (float)m.m31);
            dest.put(offset + 11, (float)m.m32);
        }

        final void putf(Matrix4x3d m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, (float)m.m00);
            dest.putFloat(offset + 4, (float)m.m01);
            dest.putFloat(offset + 8, (float)m.m02);
            dest.putFloat(offset + 12, (float)m.m10);
            dest.putFloat(offset + 16, (float)m.m11);
            dest.putFloat(offset + 20, (float)m.m12);
            dest.putFloat(offset + 24, (float)m.m20);
            dest.putFloat(offset + 28, (float)m.m21);
            dest.putFloat(offset + 32, (float)m.m22);
            dest.putFloat(offset + 36, (float)m.m30);
            dest.putFloat(offset + 40, (float)m.m31);
            dest.putFloat(offset + 44, (float)m.m32);
        }

        final void putTransposed(Matrix4d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m10);
            dest.put(offset + 2, m.m20);
            dest.put(offset + 3, m.m30);
            dest.put(offset + 4, m.m01);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m21);
            dest.put(offset + 7, m.m31);
            dest.put(offset + 8, m.m02);
            dest.put(offset + 9, m.m12);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, m.m32);
            dest.put(offset + 12, m.m03);
            dest.put(offset + 13, m.m13);
            dest.put(offset + 14, m.m23);
            dest.put(offset + 15, m.m33);
        }

        final void putTransposed(Matrix4d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00);
            dest.putDouble(offset + 8, m.m10);
            dest.putDouble(offset + 16, m.m20);
            dest.putDouble(offset + 24, m.m30);
            dest.putDouble(offset + 32, m.m01);
            dest.putDouble(offset + 40, m.m11);
            dest.putDouble(offset + 48, m.m21);
            dest.putDouble(offset + 56, m.m31);
            dest.putDouble(offset + 64, m.m02);
            dest.putDouble(offset + 72, m.m12);
            dest.putDouble(offset + 80, m.m22);
            dest.putDouble(offset + 88, m.m32);
            dest.putDouble(offset + 96, m.m03);
            dest.putDouble(offset + 104, m.m13);
            dest.putDouble(offset + 112, m.m23);
            dest.putDouble(offset + 120, m.m33);
        }

        final void put4x3Transposed(Matrix4d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m10);
            dest.put(offset + 2, m.m20);
            dest.put(offset + 3, m.m30);
            dest.put(offset + 4, m.m01);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m21);
            dest.put(offset + 7, m.m31);
            dest.put(offset + 8, m.m02);
            dest.put(offset + 9, m.m12);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, m.m32);
        }

        final void put4x3Transposed(Matrix4d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00);
            dest.putDouble(offset + 8, m.m10);
            dest.putDouble(offset + 16, m.m20);
            dest.putDouble(offset + 24, m.m30);
            dest.putDouble(offset + 32, m.m01);
            dest.putDouble(offset + 40, m.m11);
            dest.putDouble(offset + 48, m.m21);
            dest.putDouble(offset + 56, m.m31);
            dest.putDouble(offset + 64, m.m02);
            dest.putDouble(offset + 72, m.m12);
            dest.putDouble(offset + 80, m.m22);
            dest.putDouble(offset + 88, m.m32);
        }

        final void putTransposed(Matrix4x3d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m10);
            dest.put(offset + 2, m.m20);
            dest.put(offset + 3, m.m30);
            dest.put(offset + 4, m.m01);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m21);
            dest.put(offset + 7, m.m31);
            dest.put(offset + 8, m.m02);
            dest.put(offset + 9, m.m12);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, m.m32);
        }

        final void putTransposed(Matrix4x3d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00);
            dest.putDouble(offset + 4, m.m10);
            dest.putDouble(offset + 8, m.m20);
            dest.putDouble(offset + 12, m.m30);
            dest.putDouble(offset + 16, m.m01);
            dest.putDouble(offset + 20, m.m11);
            dest.putDouble(offset + 24, m.m21);
            dest.putDouble(offset + 28, m.m31);
            dest.putDouble(offset + 32, m.m02);
            dest.putDouble(offset + 36, m.m12);
            dest.putDouble(offset + 40, m.m22);
            dest.putDouble(offset + 44, m.m32);
        }

        final void putfTransposed(Matrix4x3d m, int offset, FloatBuffer dest) {
            dest.put(offset, (float)m.m00);
            dest.put(offset + 1, (float)m.m10);
            dest.put(offset + 2, (float)m.m20);
            dest.put(offset + 3, (float)m.m30);
            dest.put(offset + 4, (float)m.m01);
            dest.put(offset + 5, (float)m.m11);
            dest.put(offset + 6, (float)m.m21);
            dest.put(offset + 7, (float)m.m31);
            dest.put(offset + 8, (float)m.m02);
            dest.put(offset + 9, (float)m.m12);
            dest.put(offset + 10, (float)m.m22);
            dest.put(offset + 11, (float)m.m32);
        }

        final void putfTransposed(Matrix4x3d m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, (float)m.m00);
            dest.putFloat(offset + 4, (float)m.m10);
            dest.putFloat(offset + 8, (float)m.m20);
            dest.putFloat(offset + 12, (float)m.m30);
            dest.putFloat(offset + 16, (float)m.m01);
            dest.putFloat(offset + 20, (float)m.m11);
            dest.putFloat(offset + 24, (float)m.m21);
            dest.putFloat(offset + 28, (float)m.m31);
            dest.putFloat(offset + 32, (float)m.m02);
            dest.putFloat(offset + 36, (float)m.m12);
            dest.putFloat(offset + 40, (float)m.m22);
            dest.putFloat(offset + 44, (float)m.m32);
        }

        final void putfTransposed(Matrix4d m, int offset, FloatBuffer dest) {
            dest.put(offset, (float)m.m00);
            dest.put(offset + 1, (float)m.m10);
            dest.put(offset + 2, (float)m.m20);
            dest.put(offset + 3, (float)m.m30);
            dest.put(offset + 4, (float)m.m01);
            dest.put(offset + 5, (float)m.m11);
            dest.put(offset + 6, (float)m.m21);
            dest.put(offset + 7, (float)m.m31);
            dest.put(offset + 8, (float)m.m02);
            dest.put(offset + 9, (float)m.m12);
            dest.put(offset + 10, (float)m.m22);
            dest.put(offset + 11, (float)m.m32);
            dest.put(offset + 12, (float)m.m03);
            dest.put(offset + 13, (float)m.m13);
            dest.put(offset + 14, (float)m.m23);
            dest.put(offset + 15, (float)m.m33);
        }

        final void putfTransposed(Matrix4d m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, (float)m.m00);
            dest.putFloat(offset + 4, (float)m.m10);
            dest.putFloat(offset + 8, (float)m.m20);
            dest.putFloat(offset + 12, (float)m.m30);
            dest.putFloat(offset + 16, (float)m.m01);
            dest.putFloat(offset + 20, (float)m.m11);
            dest.putFloat(offset + 24, (float)m.m21);
            dest.putFloat(offset + 28, (float)m.m31);
            dest.putFloat(offset + 32, (float)m.m02);
            dest.putFloat(offset + 36, (float)m.m12);
            dest.putFloat(offset + 40, (float)m.m22);
            dest.putFloat(offset + 44, (float)m.m32);
            dest.putFloat(offset + 48, (float)m.m03);
            dest.putFloat(offset + 52, (float)m.m13);
            dest.putFloat(offset + 56, (float)m.m23);
            dest.putFloat(offset + 60, (float)m.m33);
        }

        final void put(Matrix3f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m01);
            dest.put(offset + 2, m.m02);
            dest.put(offset + 3, m.m10);
            dest.put(offset + 4, m.m11);
            dest.put(offset + 5, m.m12);
            dest.put(offset + 6, m.m20);
            dest.put(offset + 7, m.m21);
            dest.put(offset + 8, m.m22);
        }

        final void put(Matrix3f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00);
            dest.putFloat(offset + 4, m.m01);
            dest.putFloat(offset + 8, m.m02);
            dest.putFloat(offset + 12, m.m10);
            dest.putFloat(offset + 16, m.m11);
            dest.putFloat(offset + 20, m.m12);
            dest.putFloat(offset + 24, m.m20);
            dest.putFloat(offset + 28, m.m21);
            dest.putFloat(offset + 32, m.m22);
        }

        final void put(Matrix3d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m01);
            dest.put(offset + 2, m.m02);
            dest.put(offset + 3, m.m10);
            dest.put(offset + 4, m.m11);
            dest.put(offset + 5, m.m12);
            dest.put(offset + 6, m.m20);
            dest.put(offset + 7, m.m21);
            dest.put(offset + 8, m.m22);
        }

        final void put(Matrix3d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00);
            dest.putDouble(offset + 8, m.m01);
            dest.putDouble(offset + 16, m.m02);
            dest.putDouble(offset + 24, m.m10);
            dest.putDouble(offset + 32, m.m11);
            dest.putDouble(offset + 40, m.m12);
            dest.putDouble(offset + 48, m.m20);
            dest.putDouble(offset + 56, m.m21);
            dest.putDouble(offset + 64, m.m22);
        }

        final void putf(Matrix3d m, int offset, FloatBuffer dest) {
            dest.put(offset, (float)m.m00);
            dest.put(offset + 1, (float)m.m01);
            dest.put(offset + 2, (float)m.m02);
            dest.put(offset + 3, (float)m.m10);
            dest.put(offset + 4, (float)m.m11);
            dest.put(offset + 5, (float)m.m12);
            dest.put(offset + 6, (float)m.m20);
            dest.put(offset + 7, (float)m.m21);
            dest.put(offset + 8, (float)m.m22);
        }

        final void putf(Matrix3d m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, (float)m.m00);
            dest.putFloat(offset + 4, (float)m.m01);
            dest.putFloat(offset + 8, (float)m.m02);
            dest.putFloat(offset + 12, (float)m.m10);
            dest.putFloat(offset + 16, (float)m.m11);
            dest.putFloat(offset + 20, (float)m.m12);
            dest.putFloat(offset + 24, (float)m.m20);
            dest.putFloat(offset + 28, (float)m.m21);
            dest.putFloat(offset + 32, (float)m.m22);
        }

        final void get(Matrix4f m, int offset, FloatBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m03 = src.get(offset + 3);
            m.m10 = src.get(offset + 4);
            m.m11 = src.get(offset + 5);
            m.m12 = src.get(offset + 6);
            m.m13 = src.get(offset + 7);
            m.m20 = src.get(offset + 8);
            m.m21 = src.get(offset + 9);
            m.m22 = src.get(offset + 10);
            m.m23 = src.get(offset + 11);
            m.m30 = src.get(offset + 12);
            m.m31 = src.get(offset + 13);
            m.m32 = src.get(offset + 14);
            m.m33 = src.get(offset + 15);
        }

        final void get(Matrix4f m, int offset, ByteBuffer src) {
            m.m00 = src.getFloat(offset);
            m.m01 = src.getFloat(offset + 4);
            m.m02 = src.getFloat(offset + 8);
            m.m03 = src.getFloat(offset + 12);
            m.m10 = src.getFloat(offset + 16);
            m.m11 = src.getFloat(offset + 20);
            m.m12 = src.getFloat(offset + 24);
            m.m13 = src.getFloat(offset + 28);
            m.m20 = src.getFloat(offset + 32);
            m.m21 = src.getFloat(offset + 36);
            m.m22 = src.getFloat(offset + 40);
            m.m23 = src.getFloat(offset + 44);
            m.m30 = src.getFloat(offset + 48);
            m.m31 = src.getFloat(offset + 52);
            m.m32 = src.getFloat(offset + 56);
            m.m33 = src.getFloat(offset + 60);
        }

        final void get(Matrix4x3f m, int offset, FloatBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m10 = src.get(offset + 3);
            m.m11 = src.get(offset + 4);
            m.m12 = src.get(offset + 5);
            m.m20 = src.get(offset + 6);
            m.m21 = src.get(offset + 7);
            m.m22 = src.get(offset + 8);
            m.m30 = src.get(offset + 9);
            m.m31 = src.get(offset + 10);
            m.m32 = src.get(offset + 11);
        }

        final void get(Matrix4x3f m, int offset, ByteBuffer src) {
            m.m00 = src.getFloat(offset);
            m.m01 = src.getFloat(offset + 4);
            m.m02 = src.getFloat(offset + 8);
            m.m10 = src.getFloat(offset + 12);
            m.m11 = src.getFloat(offset + 16);
            m.m12 = src.getFloat(offset + 20);
            m.m20 = src.getFloat(offset + 24);
            m.m21 = src.getFloat(offset + 28);
            m.m22 = src.getFloat(offset + 32);
            m.m30 = src.getFloat(offset + 36);
            m.m31 = src.getFloat(offset + 40);
            m.m32 = src.getFloat(offset + 44);
        }

        final void get(Matrix4d m, int offset, DoubleBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m03 = src.get(offset + 3);
            m.m10 = src.get(offset + 4);
            m.m11 = src.get(offset + 5);
            m.m12 = src.get(offset + 6);
            m.m13 = src.get(offset + 7);
            m.m20 = src.get(offset + 8);
            m.m21 = src.get(offset + 9);
            m.m22 = src.get(offset + 10);
            m.m23 = src.get(offset + 11);
            m.m30 = src.get(offset + 12);
            m.m31 = src.get(offset + 13);
            m.m32 = src.get(offset + 14);
            m.m33 = src.get(offset + 15);
        }

        final void get(Matrix4d m, int offset, ByteBuffer src) {
            m.m00 = src.getDouble(offset);
            m.m01 = src.getDouble(offset + 8);
            m.m02 = src.getDouble(offset + 16);
            m.m03 = src.getDouble(offset + 24);
            m.m10 = src.getDouble(offset + 32);
            m.m11 = src.getDouble(offset + 40);
            m.m12 = src.getDouble(offset + 48);
            m.m13 = src.getDouble(offset + 56);
            m.m20 = src.getDouble(offset + 64);
            m.m21 = src.getDouble(offset + 72);
            m.m22 = src.getDouble(offset + 80);
            m.m23 = src.getDouble(offset + 88);
            m.m30 = src.getDouble(offset + 96);
            m.m31 = src.getDouble(offset + 104);
            m.m32 = src.getDouble(offset + 112);
            m.m33 = src.getDouble(offset + 120);
        }

        final void get(Matrix4x3d m, int offset, DoubleBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m10 = src.get(offset + 3);
            m.m11 = src.get(offset + 4);
            m.m12 = src.get(offset + 5);
            m.m20 = src.get(offset + 6);
            m.m21 = src.get(offset + 7);
            m.m22 = src.get(offset + 8);
            m.m30 = src.get(offset + 9);
            m.m31 = src.get(offset + 10);
            m.m32 = src.get(offset + 11);
        }

        final void get(Matrix4x3d m, int offset, ByteBuffer src) {
            m.m00 = src.getDouble(offset);
            m.m01 = src.getDouble(offset + 8);
            m.m02 = src.getDouble(offset + 16);
            m.m10 = src.getDouble(offset + 24);
            m.m11 = src.getDouble(offset + 32);
            m.m12 = src.getDouble(offset + 40);
            m.m20 = src.getDouble(offset + 48);
            m.m21 = src.getDouble(offset + 56);
            m.m22 = src.getDouble(offset + 64);
            m.m30 = src.getDouble(offset + 72);
            m.m31 = src.getDouble(offset + 80);
            m.m32 = src.getDouble(offset + 88);
        }

        final void getf(Matrix4d m, int offset, FloatBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m03 = src.get(offset + 3);
            m.m10 = src.get(offset + 4);
            m.m11 = src.get(offset + 5);
            m.m12 = src.get(offset + 6);
            m.m13 = src.get(offset + 7);
            m.m20 = src.get(offset + 8);
            m.m21 = src.get(offset + 9);
            m.m22 = src.get(offset + 10);
            m.m23 = src.get(offset + 11);
            m.m30 = src.get(offset + 12);
            m.m31 = src.get(offset + 13);
            m.m32 = src.get(offset + 14);
            m.m33 = src.get(offset + 15);
        }

        final void getf(Matrix4d m, int offset, ByteBuffer src) {
            m.m00 = src.getFloat(offset);
            m.m01 = src.getFloat(offset + 4);
            m.m02 = src.getFloat(offset + 8);
            m.m03 = src.getFloat(offset + 12);
            m.m10 = src.getFloat(offset + 16);
            m.m11 = src.getFloat(offset + 20);
            m.m12 = src.getFloat(offset + 24);
            m.m13 = src.getFloat(offset + 28);
            m.m20 = src.getFloat(offset + 32);
            m.m21 = src.getFloat(offset + 36);
            m.m22 = src.getFloat(offset + 40);
            m.m23 = src.getFloat(offset + 44);
            m.m30 = src.getFloat(offset + 48);
            m.m31 = src.getFloat(offset + 52);
            m.m32 = src.getFloat(offset + 56);
            m.m33 = src.getFloat(offset + 60);
        }

        final void getf(Matrix4x3d m, int offset, FloatBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m10 = src.get(offset + 3);
            m.m11 = src.get(offset + 4);
            m.m12 = src.get(offset + 5);
            m.m20 = src.get(offset + 6);
            m.m21 = src.get(offset + 7);
            m.m22 = src.get(offset + 8);
            m.m30 = src.get(offset + 9);
            m.m31 = src.get(offset + 10);
            m.m32 = src.get(offset + 11);
        }

        final void getf(Matrix4x3d m, int offset, ByteBuffer src) {
            m.m00 = src.getFloat(offset);
            m.m01 = src.getFloat(offset + 4);
            m.m02 = src.getFloat(offset + 8);
            m.m10 = src.getFloat(offset + 12);
            m.m11 = src.getFloat(offset + 16);
            m.m12 = src.getFloat(offset + 20);
            m.m20 = src.getFloat(offset + 24);
            m.m21 = src.getFloat(offset + 28);
            m.m22 = src.getFloat(offset + 32);
            m.m30 = src.getFloat(offset + 36);
            m.m31 = src.getFloat(offset + 40);
            m.m32 = src.getFloat(offset + 44);
        }

        final void get(Matrix3f m, int offset, FloatBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m10 = src.get(offset + 3);
            m.m11 = src.get(offset + 4);
            m.m12 = src.get(offset + 5);
            m.m20 = src.get(offset + 6);
            m.m21 = src.get(offset + 7);
            m.m22 = src.get(offset + 8);
        }

        final void get(Matrix3f m, int offset, ByteBuffer src) {
            m.m00 = src.getFloat(offset);
            m.m01 = src.getFloat(offset + 4);
            m.m02 = src.getFloat(offset + 8);
            m.m10 = src.getFloat(offset + 12);
            m.m11 = src.getFloat(offset + 16);
            m.m12 = src.getFloat(offset + 20);
            m.m20 = src.getFloat(offset + 24);
            m.m21 = src.getFloat(offset + 28);
            m.m22 = src.getFloat(offset + 32);
        }

        final void get(Matrix3d m, int offset, DoubleBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m10 = src.get(offset + 3);
            m.m11 = src.get(offset + 4);
            m.m12 = src.get(offset + 5);
            m.m20 = src.get(offset + 6);
            m.m21 = src.get(offset + 7);
            m.m22 = src.get(offset + 8);
        }

        final void get(Matrix3d m, int offset, ByteBuffer src) {
            m.m00 = src.getDouble(offset);
            m.m01 = src.getDouble(offset + 8);
            m.m02 = src.getDouble(offset + 16);
            m.m10 = src.getDouble(offset + 24);
            m.m11 = src.getDouble(offset + 32);
            m.m12 = src.getDouble(offset + 40);
            m.m20 = src.getDouble(offset + 48);
            m.m21 = src.getDouble(offset + 56);
            m.m22 = src.getDouble(offset + 64);
        }

        final void getf(Matrix3d m, int offset, FloatBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m10 = src.get(offset + 3);
            m.m11 = src.get(offset + 4);
            m.m12 = src.get(offset + 5);
            m.m20 = src.get(offset + 6);
            m.m21 = src.get(offset + 7);
            m.m22 = src.get(offset + 8);
        }

        final void getf(Matrix3d m, int offset, ByteBuffer src) {
            m.m00 = src.getFloat(offset);
            m.m01 = src.getFloat(offset + 4);
            m.m02 = src.getFloat(offset + 8);
            m.m10 = src.getFloat(offset + 12);
            m.m11 = src.getFloat(offset + 16);
            m.m12 = src.getFloat(offset + 20);
            m.m20 = src.getFloat(offset + 24);
            m.m21 = src.getFloat(offset + 28);
            m.m22 = src.getFloat(offset + 32);
        }

        final void copy(Matrix4f src, Matrix4f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m03 = src.m03;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m13 = src.m13;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
            dest.m23 = src.m23;
            dest.m30 = src.m30;
            dest.m31 = src.m31;
            dest.m32 = src.m32;
            dest.m33 = src.m33;
        }

        final void copy(Matrix3f src, Matrix4f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m03 = 0.0f;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m13 = 0.0f;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
            dest.m23 = 0.0f;
            dest.m30 = 0.0f;
            dest.m31 = 0.0f;
            dest.m32 = 0.0f;
            dest.m33 = 1.0f;
        }

        final void copy(Matrix4f src, Matrix3f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
        }

        final void copy(Matrix3f src, Matrix4x3f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
            dest.m30 = 0.0f;
            dest.m31 = 0.0f;
            dest.m32 = 0.0f;
        }

        final void copy3x3(Matrix4f src, Matrix4f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
        }

        final void copy4x3(Matrix4x3f src, Matrix4f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
            dest.m30 = src.m30;
            dest.m31 = src.m31;
            dest.m32 = src.m32;
        }

        final void copy4x3(Matrix4f src, Matrix4f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
            dest.m30 = src.m30;
            dest.m31 = src.m31;
            dest.m32 = src.m32;
        }

        final void copy(Matrix4f src, Matrix4x3f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
            dest.m30 = src.m30;
            dest.m31 = src.m31;
            dest.m32 = src.m32;
        }

        final void copy(Matrix4x3f src, Matrix4x3f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
            dest.m30 = src.m30;
            dest.m31 = src.m31;
            dest.m32 = src.m32;
        }

        final void copy(Matrix3f src, Matrix3f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
        }

        final void identity(Matrix4f dest) {
            dest.m00 = 1.0f;
            dest.m01 = 0.0f;
            dest.m02 = 0.0f;
            dest.m03 = 0.0f;
            dest.m10 = 0.0f;
            dest.m11 = 1.0f;
            dest.m12 = 0.0f;
            dest.m13 = 0.0f;
            dest.m20 = 0.0f;
            dest.m21 = 0.0f;
            dest.m22 = 1.0f;
            dest.m23 = 0.0f;
            dest.m30 = 0.0f;
            dest.m31 = 0.0f;
            dest.m32 = 0.0f;
            dest.m33 = 1.0f;
        }

        final void identity(Matrix4x3f dest) {
            dest.m00 = 1.0f;
            dest.m01 = 0.0f;
            dest.m02 = 0.0f;
            dest.m10 = 0.0f;
            dest.m11 = 1.0f;
            dest.m12 = 0.0f;
            dest.m20 = 0.0f;
            dest.m21 = 0.0f;
            dest.m22 = 1.0f;
            dest.m30 = 0.0f;
            dest.m31 = 0.0f;
            dest.m32 = 0.0f;
        }

        final void identity(Matrix3f dest) {
            dest.m00 = 1.0f;
            dest.m01 = 0.0f;
            dest.m02 = 0.0f;
            dest.m10 = 0.0f;
            dest.m11 = 1.0f;
            dest.m12 = 0.0f;
            dest.m20 = 0.0f;
            dest.m21 = 0.0f;
            dest.m22 = 1.0f;
        }

        void swap(Matrix4f m1, Matrix4f m2) {
            float tmp = m1.m00;
            m1.m00 = m2.m00;
            m2.m00 = tmp;
            tmp = m1.m01;
            m1.m01 = m2.m01;
            m2.m01 = tmp;
            tmp = m1.m02;
            m1.m02 = m2.m02;
            m2.m02 = tmp;
            tmp = m1.m03;
            m1.m03 = m2.m03;
            m2.m03 = tmp;
            tmp = m1.m10;
            m1.m10 = m2.m10;
            m2.m10 = tmp;
            tmp = m1.m11;
            m1.m11 = m2.m11;
            m2.m11 = tmp;
            tmp = m1.m12;
            m1.m12 = m2.m12;
            m2.m12 = tmp;
            tmp = m1.m13;
            m1.m13 = m2.m13;
            m2.m13 = tmp;
            tmp = m1.m20;
            m1.m20 = m2.m20;
            m2.m20 = tmp;
            tmp = m1.m21;
            m1.m21 = m2.m21;
            m2.m21 = tmp;
            tmp = m1.m22;
            m1.m22 = m2.m22;
            m2.m22 = tmp;
            tmp = m1.m23;
            m1.m23 = m2.m23;
            m2.m23 = tmp;
            tmp = m1.m30;
            m1.m30 = m2.m30;
            m2.m30 = tmp;
            tmp = m1.m31;
            m1.m31 = m2.m31;
            m2.m31 = tmp;
            tmp = m1.m32;
            m1.m32 = m2.m32;
            m2.m32 = tmp;
            tmp = m1.m33;
            m1.m33 = m2.m33;
            m2.m33 = tmp;
        }

        void swap(Matrix4x3f m1, Matrix4x3f m2) {
            float tmp = m1.m00;
            m1.m00 = m2.m00;
            m2.m00 = tmp;
            tmp = m1.m01;
            m1.m01 = m2.m01;
            m2.m01 = tmp;
            tmp = m1.m02;
            m1.m02 = m2.m02;
            m2.m02 = tmp;
            tmp = m1.m10;
            m1.m10 = m2.m10;
            m2.m10 = tmp;
            tmp = m1.m11;
            m1.m11 = m2.m11;
            m2.m11 = tmp;
            tmp = m1.m12;
            m1.m12 = m2.m12;
            m2.m12 = tmp;
            tmp = m1.m20;
            m1.m20 = m2.m20;
            m2.m20 = tmp;
            tmp = m1.m21;
            m1.m21 = m2.m21;
            m2.m21 = tmp;
            tmp = m1.m22;
            m1.m22 = m2.m22;
            m2.m22 = tmp;
            tmp = m1.m30;
            m1.m30 = m2.m30;
            m2.m30 = tmp;
            tmp = m1.m31;
            m1.m31 = m2.m31;
            m2.m31 = tmp;
            tmp = m1.m32;
            m1.m32 = m2.m32;
            m2.m32 = tmp;
        }

        void swap(Matrix3f m1, Matrix3f m2) {
            float tmp = m1.m00;
            m1.m00 = m2.m00;
            m2.m00 = tmp;
            tmp = m1.m01;
            m1.m01 = m2.m01;
            m2.m01 = tmp;
            tmp = m1.m02;
            m1.m02 = m2.m02;
            m2.m02 = tmp;
            tmp = m1.m10;
            m1.m10 = m2.m10;
            m2.m10 = tmp;
            tmp = m1.m11;
            m1.m11 = m2.m11;
            m2.m11 = tmp;
            tmp = m1.m12;
            m1.m12 = m2.m12;
            m2.m12 = tmp;
            tmp = m1.m20;
            m1.m20 = m2.m20;
            m2.m20 = tmp;
            tmp = m1.m21;
            m1.m21 = m2.m21;
            m2.m21 = tmp;
            tmp = m1.m22;
            m1.m22 = m2.m22;
            m2.m22 = tmp;
        }

        final void zero(Matrix4f dest) {
            dest.m00 = 0.0f;
            dest.m01 = 0.0f;
            dest.m02 = 0.0f;
            dest.m03 = 0.0f;
            dest.m10 = 0.0f;
            dest.m11 = 0.0f;
            dest.m12 = 0.0f;
            dest.m13 = 0.0f;
            dest.m20 = 0.0f;
            dest.m21 = 0.0f;
            dest.m22 = 0.0f;
            dest.m23 = 0.0f;
            dest.m30 = 0.0f;
            dest.m31 = 0.0f;
            dest.m32 = 0.0f;
            dest.m33 = 0.0f;
        }

        final void zero(Matrix4x3f dest) {
            dest.m00 = 0.0f;
            dest.m01 = 0.0f;
            dest.m02 = 0.0f;
            dest.m10 = 0.0f;
            dest.m11 = 0.0f;
            dest.m12 = 0.0f;
            dest.m20 = 0.0f;
            dest.m21 = 0.0f;
            dest.m22 = 0.0f;
            dest.m30 = 0.0f;
            dest.m31 = 0.0f;
            dest.m32 = 0.0f;
        }

        final void zero(Matrix3f dest) {
            dest.m00 = 0.0f;
            dest.m01 = 0.0f;
            dest.m02 = 0.0f;
            dest.m10 = 0.0f;
            dest.m11 = 0.0f;
            dest.m12 = 0.0f;
            dest.m20 = 0.0f;
            dest.m21 = 0.0f;
            dest.m22 = 0.0f;
        }

        final void putMatrix3f(Quaternionf q, int position, ByteBuffer dest) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            dest.putFloat(position, 1.0f - q11 - q22);
            dest.putFloat(position + 4, q01 + q23);
            dest.putFloat(position + 8, q02 - q13);
            dest.putFloat(position + 12, q01 - q23);
            dest.putFloat(position + 16, 1.0f - q22 - q00);
            dest.putFloat(position + 20, q12 + q03);
            dest.putFloat(position + 24, q02 + q13);
            dest.putFloat(position + 28, q12 - q03);
            dest.putFloat(position + 32, 1.0f - q11 - q00);
        }

        final void putMatrix3f(Quaternionf q, int position, FloatBuffer dest) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            dest.put(position, 1.0f - q11 - q22);
            dest.put(position + 1, q01 + q23);
            dest.put(position + 2, q02 - q13);
            dest.put(position + 3, q01 - q23);
            dest.put(position + 4, 1.0f - q22 - q00);
            dest.put(position + 5, q12 + q03);
            dest.put(position + 6, q02 + q13);
            dest.put(position + 7, q12 - q03);
            dest.put(position + 8, 1.0f - q11 - q00);
        }

        final void putMatrix4f(Quaternionf q, int position, ByteBuffer dest) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            dest.putFloat(position, 1.0f - q11 - q22);
            dest.putFloat(position + 4, q01 + q23);
            dest.putFloat(position + 8, q02 - q13);
            dest.putFloat(position + 12, 0.0f);
            dest.putFloat(position + 16, q01 - q23);
            dest.putFloat(position + 20, 1.0f - q22 - q00);
            dest.putFloat(position + 24, q12 + q03);
            dest.putFloat(position + 28, 0.0f);
            dest.putFloat(position + 32, q02 + q13);
            dest.putFloat(position + 36, q12 - q03);
            dest.putFloat(position + 40, 1.0f - q11 - q00);
            dest.putFloat(position + 44, 0.0f);
            dest.putLong(position + 48, 0L);
            dest.putLong(position + 56, 4575657221408423936L);
        }

        final void putMatrix4f(Quaternionf q, int position, FloatBuffer dest) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            dest.put(position, 1.0f - q11 - q22);
            dest.put(position + 1, q01 + q23);
            dest.put(position + 2, q02 - q13);
            dest.put(position + 3, 0.0f);
            dest.put(position + 4, q01 - q23);
            dest.put(position + 5, 1.0f - q22 - q00);
            dest.put(position + 6, q12 + q03);
            dest.put(position + 7, 0.0f);
            dest.put(position + 8, q02 + q13);
            dest.put(position + 9, q12 - q03);
            dest.put(position + 10, 1.0f - q11 - q00);
            dest.put(position + 11, 0.0f);
            dest.put(position + 12, 0.0f);
            dest.put(position + 13, 0.0f);
            dest.put(position + 14, 0.0f);
            dest.put(position + 15, 1.0f);
        }

        final void putMatrix4x3f(Quaternionf q, int position, ByteBuffer dest) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            dest.putFloat(position, 1.0f - q11 - q22);
            dest.putFloat(position + 4, q01 + q23);
            dest.putFloat(position + 8, q02 - q13);
            dest.putFloat(position + 12, q01 - q23);
            dest.putFloat(position + 16, 1.0f - q22 - q00);
            dest.putFloat(position + 20, q12 + q03);
            dest.putFloat(position + 24, q02 + q13);
            dest.putFloat(position + 28, q12 - q03);
            dest.putFloat(position + 32, 1.0f - q11 - q00);
            dest.putLong(position + 36, 0L);
            dest.putFloat(position + 44, 0.0f);
        }

        final void putMatrix4x3f(Quaternionf q, int position, FloatBuffer dest) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            dest.put(position, 1.0f - q11 - q22);
            dest.put(position + 1, q01 + q23);
            dest.put(position + 2, q02 - q13);
            dest.put(position + 3, q01 - q23);
            dest.put(position + 4, 1.0f - q22 - q00);
            dest.put(position + 5, q12 + q03);
            dest.put(position + 6, q02 + q13);
            dest.put(position + 7, q12 - q03);
            dest.put(position + 8, 1.0f - q11 - q00);
            dest.put(position + 9, 0.0f);
            dest.put(position + 10, 0.0f);
            dest.put(position + 11, 0.0f);
        }
    }
}

