/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Vector2i;
import org.joml.Vector3d;

public class Vector3i
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public int x;
    public int y;
    public int z;

    public Vector3i() {
    }

    public Vector3i(int d) {
        this(d, d, d);
    }

    public Vector3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3i(Vector3i v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vector3i(Vector2i v, int z) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
    }

    public Vector3i(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector3i(int index, ByteBuffer buffer) {
        this.x = buffer.getInt(index);
        this.y = buffer.getInt(index + 4);
        this.z = buffer.getInt(index + 8);
    }

    public Vector3i(IntBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector3i(int index, IntBuffer buffer) {
        this.x = buffer.get(index);
        this.y = buffer.get(index + 1);
        this.z = buffer.get(index + 2);
    }

    public Vector3i set(Vector3i v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        return this;
    }

    public Vector3i set(Vector3d v) {
        this.x = (int)v.x;
        this.y = (int)v.y;
        this.z = (int)v.z;
        return this;
    }

    public Vector3i set(Vector2i v, int z) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
        return this;
    }

    public Vector3i set(int d) {
        return this.set(d, d, d);
    }

    public Vector3i set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3i set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector3i set(int index, ByteBuffer buffer) {
        this.x = buffer.getInt(index);
        this.y = buffer.getInt(index + 4);
        this.z = buffer.getInt(index + 8);
        return this;
    }

    public Vector3i set(IntBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector3i set(int index, IntBuffer buffer) {
        this.x = buffer.get(index);
        this.y = buffer.get(index + 1);
        this.z = buffer.get(index + 2);
        return this;
    }

    public IntBuffer get(IntBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public IntBuffer get(int index, IntBuffer buffer) {
        buffer.put(index, this.x);
        buffer.put(index + 1, this.y);
        buffer.put(index + 2, this.z);
        return buffer;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        buffer.putInt(index, this.x);
        buffer.putInt(index + 4, this.y);
        buffer.putInt(index + 8, this.z);
        return buffer;
    }

    public Vector3i sub(Vector3i v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    public Vector3i sub(Vector3i v, Vector3i dest) {
        dest.x = this.x - v.x;
        dest.y = this.y - v.y;
        dest.z = this.z - v.z;
        return dest;
    }

    public Vector3i sub(int x, int y, int z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vector3i sub(int x, int y, int z, Vector3i dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        dest.z = this.z - z;
        return dest;
    }

    public Vector3i add(Vector3i v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public Vector3i add(Vector3i v, Vector3i dest) {
        dest.x = this.x + v.x;
        dest.y = this.y + v.y;
        dest.z = this.z + v.z;
        return dest;
    }

    public Vector3i add(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3i add(int x, int y, int z, Vector3i dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        dest.z = this.z + z;
        return dest;
    }

    public Vector3i mul(int scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        return this;
    }

    public Vector3i mul(int scalar, Vector3i dest) {
        dest.x = this.x * scalar;
        dest.y = this.y * scalar;
        dest.y = this.z * scalar;
        return dest;
    }

    public Vector3i mul(Vector3i v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public Vector3i mul(Vector3i v, Vector3i dest) {
        dest.x = this.x * v.x;
        dest.y = this.y * v.y;
        dest.z = this.z * v.z;
        return dest;
    }

    public Vector3i mul(int x, int y, int z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vector3i mul(int x, int y, int z, Vector3i dest) {
        dest.x = this.x * x;
        dest.y = this.y * y;
        dest.z = this.z * z;
        return dest;
    }

    public long lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double distance(Vector3i v) {
        return Math.sqrt(this.distanceSquared(v));
    }

    public double distance(int x, int y, int z) {
        return Math.sqrt(this.distanceSquared(x, y, z));
    }

    public long distanceSquared(Vector3i v) {
        int dx = this.x - v.x;
        int dy = this.y - v.y;
        int dz = this.z - v.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public long distanceSquared(int x, int y, int z) {
        int dx = this.x - x;
        int dy = this.y - y;
        int dz = this.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public Vector3i zero() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
        return this;
    }

    public String toString() {
        return "(" + this.x + " " + this.y + " " + this.z + ")";
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + " " + formatter.format(this.z) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.z);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readInt();
        this.y = in.readInt();
        this.z = in.readInt();
    }

    public Vector3i negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3i negate(Vector3i dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3i other = (Vector3i)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }
}

