import { Component, inject, OnInit } from '@angular/core';
import { UserService } from '../services/user';
import { User } from '../models/user';

@Component({
  selector: 'app-users',
  imports: [],
  templateUrl: './users.html',
  styleUrl: './users.css',
})
export class Users implements OnInit {
  allUsers: User[] = []

  private userService = inject(UserService)

  ngOnInit(): void {
    this.userService.getAllUsers().subscribe((data=>{
      this.allUsers = data
    }))
  }

  getUser(){
    this.userService.getUser("pera").subscribe((data=>{
        if(data){
          alert("Pera postoji!")
        }
    }))
  }
}
