import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { User } from '../models/user';
import { Message } from '../models/message';

@Injectable({
  providedIn: 'root',
})
export class UserService {
  private http = inject(HttpClient)

  backendUrl : string = `http://localhost:8080/users`;

  getAllUsers(){
    return this.http.get<User[]>(this.backendUrl)
  }

  getUser(name: string){
    return this.http.get<User>(`http://localhost:8080/users/${name}`)
  }

  login(username: string, password: string) {
    const data = {
      username: username,
      password: password
    }
    return this.http.post<User>(`${this.backendUrl}/login`, data);
  }

  register(username: string, password: string, firstname: string, lastname: string) {
    const data = {
      username: username,
      password: password,
      firstname: firstname,
      lastname: lastname
    }
    return this.http.post<Message>(`${this.backendUrl}/register`, data);
  }
}
