import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { Book } from '../models/book';
import { Message } from '../models/message';

@Injectable({
  providedIn: 'root',
})
export class BookService {
  private http = inject(HttpClient)

  backendUrl : string = `http://localhost:8080/books`;

  getAllBooks(){
    return this.http.get<Book[]>(this.backendUrl)
  }

  awardBook(book: string) {
    return this.http.get<Message>(`${this.backendUrl}/award/${book}`);
  }

  deleteBook(book: string) {
    alert(`${this.backendUrl}/delete/${book}`);
    return this.http.get<Message>(`${this.backendUrl}/delete/${book}`);
  }
}
