import { Component, inject } from '@angular/core';
import { UserService } from '../services/user';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-register',
  imports: [FormsModule],
  templateUrl: './register.html',
  styleUrl: './register.css',
})
export class Register {
  username: string = ""
  password: string = ""
  firstname: string = ""
  lastname: string = ""

  private userService = inject(UserService)

  register() {
    this.userService.register(this.username, this.password, this.firstname, this.lastname).subscribe(message => {
      alert(message.message);
    })
  }
}
