import { Component, inject } from '@angular/core';
import { UserService } from '../services/user';
import { FormsModule } from '@angular/forms';
import { Router } from '@angular/router';

@Component({
  selector: 'app-login',
  imports: [FormsModule],
  templateUrl: './login.html',
  styleUrl: './login.css',
})
export class Login {
  username: string = ""
  password: string = ""

  private userService = inject(UserService);
  private router = inject(Router);

  loginMessage: string = ""

  login() {
    this.userService.login(this.username, this.password).subscribe(user => {
      if (user != null) {
        localStorage.setItem("loggedUser", user.username);
        localStorage.setItem("loggedUserObject", JSON.stringify(user));
        this.router.navigate(["/books"]);
      }
      else {
        this.loginMessage = "Wrong username or password!"
      }
    });
  }
}
