import { Component, inject } from '@angular/core';
import { Book } from '../models/book';
import { UserService } from '../services/user';
import { BookService } from '../services/book';
import { Message } from '../models/message';
import { User } from '../models/user';

@Component({
  selector: 'app-books',
  imports: [],
  templateUrl: './books.html',
  styleUrl: './books.css',
})
export class Books {
  allBooks: Book[] = []

  user: string = ""
  userObject: User = new User();

  private bookService = inject(BookService)

  ngOnInit(): void {
    this.user = localStorage.getItem("loggedUser")!;
    this.userObject = JSON.parse(localStorage.getItem("loggerdUserObject")!);

    this.bookService.getAllBooks().subscribe((data=>{
      this.allBooks = data
    }))
  }

  awardBook(book: string) {
    this.bookService.awardBook(book).subscribe(message => {
      this.bookService.getAllBooks().subscribe((data=>{
        this.allBooks = data
      }))
    })
  }

  deleteBook(book: string) {
    this.bookService.deleteBook(book).subscribe(message => {
      this.bookService.getAllBooks().subscribe((data=>{
        this.allBooks = data
      }))
    })
  }
}
