package com.example.backend.db.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.example.backend.db.DB;
import com.example.backend.models.Message;
import com.example.backend.models.User;

public class UserRepo implements UserRepoInterface {

    @Override
    public List<User> getAllUsers() {
        try (
            Connection conn = DB.source().getConnection();
            PreparedStatement pstmt = conn.prepareStatement("select * from users")
        ) {
            ResultSet rs = pstmt.executeQuery();

            List<User> allUsers = new ArrayList<>();
            while(rs.next()) {
                allUsers.add(new User(
                    rs.getString("username"), 
                    rs.getString("password"), 
                    rs.getString("firstname"), 
                    rs.getString("lastname")));
            }

            return allUsers;
        }
        catch(SQLException e) {
            e.printStackTrace();
        }

        return null;
    }

    @Override
    public User login(User user) {
        try (
            Connection conn = DB.source().getConnection();
            PreparedStatement pstmt = conn.prepareStatement
                ("select * from users where username=? and password=?");
        ) {
            pstmt.setString(1, user.getUsername());
            pstmt.setString(2, user.getPassword());

            ResultSet rs = pstmt.executeQuery();

            User foundUser = null;
            if (rs.next()) {
                foundUser = new User(
                    rs.getString("username"), 
                    rs.getString("password"), 
                    rs.getString("firstname"), 
                    rs.getString("lastname"));
            }

            return foundUser;

        } catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Message register(User newUser) {
        try (
            Connection conn = DB.source().getConnection();
            PreparedStatement pstmt = conn.prepareStatement("insert into users (username, password, firstname, lastname) values (?, ?, ?, ?)");
        ) {
            pstmt.setString(1, newUser.getUsername());
            pstmt.setString(2, newUser.getPassword());
            pstmt.setString(3, newUser.getFirstname());
            pstmt.setString(4, newUser.getLastname());

            if( pstmt.executeUpdate() > 0 ) {
                return new Message("User registered successfully.");
            }
            else {
                return new Message("Error.");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
    
}
