package com.example.backend.db.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

import com.example.backend.db.DB;
import com.example.backend.models.Book;
import com.example.backend.models.Message;

public class BookRepo implements BookRepoInterface {

    @Override
    public List<Book> getAllBooks() {
        try (
            Connection conn = DB.source().getConnection();
            PreparedStatement pstmt = conn.prepareStatement("select * from books");
        ) {
            
            ResultSet rs = pstmt.executeQuery();

            List<Book> books = new ArrayList<>();
            while (rs.next()) {
                books.add(new Book(
                    rs.getString("name"), 
                    rs.getString("author"), 
                    rs.getInt("pages"), 
                    rs.getInt("awards")
                ));
            }

            return books;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }

    @Override
    public Message awardBook(String bookName) {
        try (
            Connection conn = DB.source().getConnection();
            PreparedStatement pstmt = conn.prepareStatement("update books set awards = awards + 1 where name = ?");
        ) {
            pstmt.setString(1, bookName);

            if( pstmt.executeUpdate() > 0 ) {
                return new Message("Book awarded!");
            }
            else {
                return new Message("Error.");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        return null;
    }

    @Override
    public Message deleteBook(String bookName) {
        try (
            Connection conn = DB.source().getConnection();
            PreparedStatement pstmt = conn.prepareStatement("delete from books where name = ?");
        ) {
            pstmt.setString(1, bookName);
            
            if ( pstmt.executeUpdate() > 0 ) {
                return new Message("Book deleted!");
            }
            else {
                return new Message("Error!");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
