package com.example.backend.controllers;

import java.util.ArrayList;
import java.util.List;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.backend.db.dao.UserRepo;
import com.example.backend.models.Message;
import com.example.backend.models.User;

import jakarta.annotation.PostConstruct;
import org.springframework.web.bind.annotation.PostMapping;


@RestController
@RequestMapping("/users")
@CrossOrigin(origins = "http://localhost:4200/")
public class UserController {

    @GetMapping("/hello")
    public String helloWorld(){
        return "Hello world";
    }

    private List<User> allUsers;

    @PostConstruct
    private void initUsers(){
        allUsers = new ArrayList<>();
        allUsers.add(new User("pera", "pera123", "pera", "peric"));
        allUsers.add(new User("pera2", "pera1234", "pera2", "peric2"));
    }

    @GetMapping("")
    public List<User> getUsers(){
        return new UserRepo().getAllUsers();
    }

    @GetMapping("/{username}")
    public User getUser(@PathVariable String username){
        for(int i=0; i<this.allUsers.size(); i++){
            if(username.equals(this.allUsers.get(i).getFirstname())){
                return this.allUsers.get(i);
        }
        }
        return null;
    }

    @PostMapping("/login")
    public User login(@RequestBody User user){
        return new UserRepo().login(user);
    }

    @PostMapping("/register")
    public Message register(@RequestBody User newUser) {
        return new UserRepo().register(newUser);        
    }
}
