package com.example.backend.controllers;

import org.springframework.web.bind.annotation.RestController;

import com.example.backend.db.dao.BookRepo;
import com.example.backend.models.Book;
import com.example.backend.models.Message;

import java.util.List;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@RestController
@RequestMapping("/books")
@CrossOrigin(origins = "http://localhost:4200/")
public class BookController {
    
    @GetMapping("") 
    public List<Book> getAllBooks() {
        return new BookRepo().getAllBooks();
    }

    @GetMapping("/award/{book}")
    public Message awardBook(@PathVariable String book) {
        return new BookRepo().awardBook(book);
    }

    @GetMapping("/delete/{book}")
    public Message deleteBook(@PathVariable String book) {
        return new BookRepo().deleteBook(book);
    }
}
