import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { User } from '../models/user';

@Injectable({
  providedIn: 'root',
})
export class UserService {
  private http = inject(HttpClient)

  getAllUsers(){
    return this.http.get<User[]>("http://localhost:8080/users")
  }

  getUser(name: string){
    return this.http.get<User>(`http://localhost:8080/users/${name}`)
  }
}
