package com.example.backend;

import java.util.ArrayList;
import java.util.List;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import jakarta.annotation.PostConstruct;

@RestController
@RequestMapping("/users")
@CrossOrigin(origins = "http://localhost:4200/")
public class UserController {

    @GetMapping("/hello")
    public String helloWorld(){
        return "Hello world";
    }

    private List<User> allUsers;

    @PostConstruct
    private void initUsers(){
        allUsers = new ArrayList<>();
        allUsers.add(new User("pera", "peric"));
        allUsers.add(new User("pera2", "peric2"));
    }

    @GetMapping("")
    public List<User> getUsers(){
        return this.allUsers;
    }

    @GetMapping("/{username}")
    public User getUser(@PathVariable String username){
        for(int i=0; i<this.allUsers.size(); i++){
            if(username.equals(this.allUsers.get(i).getFirstname())){
                return this.allUsers.get(i);
        }
        }
        return null;
    }
}
