package com.example.backend.db.repos;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import com.example.backend.db.entities.User;

import java.util.List;


public interface  UserRepository extends JpaRepository<User, Integer> {
    List<User> findByUsername(String username);

    User findByUsernameAndPassword(String username, String password);

    @Query("SELECT u.username FROM User u WHERE u.username LIKE %?1%")
    List<String> findUsersByUsernameContaining(String partOfUsername);
}
