package com.example.backend.controllers;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import com.example.backend.db.entities.User;
import com.example.backend.db.repos.UserRepository;

@RestController
public class UserController {

    @Autowired
    private UserRepository userRepository;

    @GetMapping("/getAllUsers")
    public List<User> getAllUsers(){
        return userRepository.findAll();
    }

    @GetMapping("/getNumberOfUsers")
    public Long getNumberOfUsers(){
        return userRepository.count();
    }

    @GetMapping("/find/{username}")
    public List<User> findUserByUsername(@PathVariable String username){
        return userRepository.findByUsername(username);
    }

    @PostMapping("/login")
    public User login(@RequestBody User u){
        return userRepository.findByUsernameAndPassword(u.getUsername(), u.getPassword());
    }

    @PostMapping("/addUser")
    public User addUser(@RequestBody User u){
        return userRepository.save(u);
    }

    @DeleteMapping("/delete/{id}")
    public void deleteUser(@PathVariable Integer id) {
        userRepository.deleteById(id);
    }

    @GetMapping("/findAllContaining/{usernameContaining}")
    public List<String> finfUsersByUsernameContaining(@PathVariable String usernameContaining){
        return userRepository.findUsersByUsernameContaining(usernameContaining);
    }
}
