import { Component, inject, OnInit } from '@angular/core';
import { WritersService } from '../services/writers-service';
import { Writer } from '../models/writer';
import { DatePipe } from '@angular/common';

@Component({
  selector: 'app-writers',
  imports: [DatePipe],
  templateUrl: './writers.html',
  styleUrl: './writers.css',
})
export class Writers implements OnInit {

  ngOnInit(): void {
    this.allWriters = this.writersService.getAllWriters()
  }
  
  private writersService = inject(WritersService)

  allWriters: Writer[] = []

  globalImage = "writer.png"

  sortByAwards(){
    this.allWriters = this.writersService.sortByAwards()
  }

  sortByDate(){
    this.allWriters = this.writersService.sortByDate()
  }


}
