import { Injectable } from '@angular/core';
import { Writer } from '../models/writer';

@Injectable({
  providedIn: 'root',
})
export class WritersService {

  getAllWriters(): Writer[]{
    return [
      {firstname: "pera", lastname:"peric", awards: 10, birthday: new Date("1996-12-12")},
      {firstname: "mika", lastname:"mikic", awards: 3, birthday: new Date("1998-12-12")}
    ]
  }

  sortByAwards(): Writer[]{
    return this.getAllWriters().sort((w1,w2)=>{
      return w1.awards - w2.awards
    })
  }

  sortByDate(): Writer[]{
    return this.getAllWriters().sort((w1,w2)=>{
      if(w1.birthday>w2.birthday){
        return 1
      }
      else{
        if(w1.birthday<w2.birthday) return -1
        else return 0
      }
    })
  }
  
}
