import { Component, inject, OnInit } from '@angular/core';
import { Book } from '../models/book';
import { BooksService } from '../services/books-service';
import { BookDetails } from '../book-details/book-details';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-books',
  imports: [BookDetails, FormsModule],
  templateUrl: './books.html',
  styleUrl: './books.css',
})
export class Books implements OnInit {

  ngOnInit(): void {
    this.allBooks = this.booksService.getAllBooks()
  }
  
  private booksService = inject(BooksService)

  allBooks: Book[] = []

  searchParam = ""

  search(){
    this.allBooks = this.booksService.findBooks(this.searchParam)
  }


}