import { Worker, MessagePort } from 'node:worker_threads';
import { RecordableHistogram } from 'node:perf_hooks';
import { ResponseMessage } from '../types';
import { TaskInfo } from '../task_queue';
import { kWorkerData } from '../symbols';
import { PiscinaHistogramSummary } from '../histogram';
import { AsynchronouslyCreatedResource, AsynchronouslyCreatedResourcePool } from './base';
export * from './balancer';
type ResponseCallback = (response: ResponseMessage) => void;
export type PiscinaWorker = {
    id: number;
    currentUsage: number;
    isRunningAbortableTask: boolean;
    histogram: PiscinaHistogramSummary | null;
    terminating: boolean;
    destroyed: boolean;
    [kWorkerData]: WorkerInfo;
};
export declare class WorkerInfo extends AsynchronouslyCreatedResource {
    worker: Worker;
    taskInfos: Map<number, TaskInfo>;
    idleTimeout: NodeJS.Timeout | null;
    port: MessagePort;
    sharedBuffer: Int32Array;
    lastSeenResponseCount: number;
    onMessage: ResponseCallback;
    histogram: RecordableHistogram | null;
    terminating: boolean;
    destroyed: boolean;
    constructor(worker: Worker, port: MessagePort, onMessage: ResponseCallback, enableHistogram: boolean);
    get id(): number;
    destroy(): void;
    clearIdleTimeout(): void;
    ref(): WorkerInfo;
    unref(): WorkerInfo;
    _handleResponse(message: ResponseMessage): void;
    postTask(taskInfo: TaskInfo): void;
    processPendingMessages(): void;
    isRunningAbortableTask(): boolean;
    currentUsage(): number;
    get interface(): PiscinaWorker;
}
export { AsynchronouslyCreatedResourcePool };
