import { Component, OnInit } from '@angular/core';
import { Korisnik } from '../korisnik';
import { Rezervacija } from '../rezervacija';
import { Router } from '@angular/router';

@Component({
  selector: 'app-posetilac',
  templateUrl: './posetilac.component.html',
  styleUrls: ['./posetilac.component.css']
})
export class PosetilacComponent implements OnInit {
  user: Korisnik;
  naziv: string;
  msg: string;

  pretraga: any[];

  constructor(private r: Router) { }

  ngOnInit() {
    this.user = JSON.parse(localStorage.getItem("user"));
  }

  trazi(){
    if(this.naziv=="" || this.naziv ==null){
      this.msg = "Morate uneti naziv";
    }
    var filmovi = JSON.parse(localStorage.getItem("filmovi"));
    for(var i=0; i<filmovi.length; i++){
      if(filmovi[i].naziv.indexOf(this.naziv)>=0){
        this.pretraga = [];
        var projekcije = JSON.parse(localStorage.getItem("projekcije"));
        for(var j=0; j<projekcije.length; j++){
          if(projekcije[j].idFilma==filmovi[i].idFilm){
            var dateProj = new Date(projekcije[j].datum);
            if(dateProj.getTime()>Date.now()){
              var temp: any = {};
          
              temp.idP = projekcije[j].idPr;
              temp.naziv = filmovi[i].naziv;
              temp.datum = projekcije[j].datum;
              temp.vreme = projekcije[j].vreme;
              temp.sala = projekcije[j].sala;
              this.pretraga.push(temp);
            }
            
          }
        }
        if(this.pretraga.length==0) {
          this.msg = "Nema projekcija za taj film";
          return;
        }
        else{
          this.msg="";
          return;
        }
      }
    }
    this.msg = "Ne postoji film sa tim nazivom";
  }

  rezervisi(p: any){
    var ulogovaniKorisnik = JSON.parse(localStorage.getItem("user"));
    var rezervacija = new Rezervacija();
    rezervacija.korisnik = ulogovaniKorisnik.korisnicko_ime;
    rezervacija.broj=2;
    rezervacija.datum = p.datum;
    rezervacija.idP = p.idP;
    rezervacija.naziv = p.naziv;
    rezervacija.sala = p.sala;
    rezervacija.vreme = p.vreme;

    var rezervacije = JSON.parse(localStorage.getItem("rezervacije"));
    rezervacije.push(rezervacija);
    localStorage.setItem("rezervacije", JSON.stringify(rezervacije));
    localStorage.setItem("poslednjaRezervacija", JSON.stringify(rezervacija));

    this.r.navigate(["/rezervacija"]);
  }

  logout(){
    this.r.navigate([""]);
  }

}
