import { Component, OnInit } from '@angular/core';
import { Film } from '../film';
import { Projekcija } from '../projekcija';
import { Router } from '@angular/router';

@Component({
  selector: 'app-novi-film',
  templateUrl: './novi-film.component.html',
  styleUrls: ['./novi-film.component.css']
})
export class NoviFilmComponent implements OnInit {
  filmovi: Film[];
  idF: number;
  datum: Date;
  vreme: number;
  sala: string;
  msg: string;

  constructor(private r: Router) { }

  ngOnInit() {
    this.filmovi = JSON.parse(localStorage.getItem("filmovi"));
  }

  dodaj(){
    if(this.datum==null || this.vreme==null || this.sala==null){
      this.msg = "Morate uneti sve podatke";
    }
    else{
      var projekcije = JSON.parse(localStorage.getItem("projekcije"));
      for(var i=0; i<projekcije.length; i++){
        var datumP = new Date(projekcije[i].datum);
        var datumN = new Date(this.datum);
        if(datumP.getTime()==datumN.getTime() && projekcije[i].vreme==this.vreme && projekcije[i].sala == this.sala){
          this.msg = "Ne moze u to vreme.";
          return;
        }
      }

      var projekcija = new Projekcija();
      projekcija.datum = this.datum;
      projekcija.idFilma = this.idF;
      projekcija.sala = this.sala;
      projekcija.vreme = this.vreme;
      projekcija.idPr = projekcije.length+1;

      projekcije.push(projekcija);

      localStorage.setItem("projekcije", JSON.stringify(projekcije));

      this.r.navigate(["/blagajnik"]);
    }
  }

}
