import { Component } from '@angular/core';
import { Korisnik } from './korisnik';
import { Film } from './film';
import { Projekcija } from './projekcija';
import { Rezervacija } from './rezervacija';
import { Zanr } from './zanr';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent {
  title = 'Nas bioskop';
  korisnici: Korisnik[];
  filmovi: Film[];
  projekcije: Projekcija[];
  rezervacije: Rezervacija[];

  ngOnInit(){
    this.korisnici = [
      {korisnicko_ime: "bosko", lozinka: "sifra123", ime: "Bosko" , prezime: "Nikolic", zanimanje: "profesor", tip: 1},
      {korisnicko_ime: "marina", lozinka: "sifra1234", ime: "Marina" , prezime: "Marinkovic", zanimanje: "apotekar", tip: 1},
      {korisnicko_ime: "nikola", lozinka: "sifra12345", ime: "Nikola" , prezime: "Nikolic", zanimanje: "pijanista", tip: 1},
      {korisnicko_ime: "laza", lozinka: "sifra123456", ime: "Laza" , prezime: "Lazic", zanimanje: "ekonomista", tip: 1},
      {korisnicko_ime: "blagajna", lozinka: "cineplex123", ime: "Misa" , prezime: "Milosevic", zanimanje: "blagajnik", tip: 2}
    ];

    localStorage.setItem("korisnici", JSON.stringify(this.korisnici));

    this.filmovi = [
      {idFilm: 1, naziv: "Aladin", zemlja: "SAD", godina: 2019, zanr: [Zanr.Avantura, Zanr.Komedija]},
      {idFilm: 2, naziv: "Patuljci sa naslovnih strana", zemlja: "Srbija", godina: 2018, zanr: [Zanr.Komedija]},
      {idFilm: 3, naziv: "Druga strana svega", zemlja: "Srbija", godina: 2018, zanr: [Zanr.Dokumentarni]},
      {idFilm: 4, naziv: "Stranac", zemlja: "SAD", godina: 2018, zanr: [Zanr.Akcioni, Zanr.Triler]}
    ];

    localStorage.setItem("filmovi", JSON.stringify(this.filmovi));

    this.projekcije = [
      {idPr: 1, idFilma: 2, datum: new Date("2019-06-15"), vreme: 18, sala: "A"},
      {idPr: 2, idFilma: 1, datum: new Date("2019-06-16"), vreme: 20, sala: "A"},
      {idPr: 3, idFilma: 1, datum: new Date("2019-06-16"), vreme: 22, sala: "A"},
      {idPr: 4, idFilma: 3, datum: new Date("2019-06-16"), vreme: 20, sala: "B"},
      {idPr: 5, idFilma: 3, datum: new Date("2019-06-17"), vreme: 20, sala: "A"},
      {idPr: 6, idFilma: 1, datum: new Date("2019-06-28"), vreme: 20, sala: "A"}
    ]

    localStorage.setItem("projekcije", JSON.stringify(this.projekcije));

    this.rezervacije = [];

    localStorage.setItem("rezervacije", JSON.stringify(this.rezervacije));
  }

}
