package managed_beans;

import entities.Reservation;
import java.util.Date;
import javax.enterprise.context.RequestScoped;
import javax.faces.annotation.FacesConfig;
import javax.inject.Named;
import util.dao.ReservationDAO;

@Named(value = "nastavnikMB")
@RequestScoped
@FacesConfig(version = FacesConfig.Version.JSF_2_3)
public class TeacherManagedBean {

    private String title;
    private Date from;
    private Date to;
    private String[] labs;

    private String poruka;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getFrom() {
        return from;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public Date getTo() {
        return to;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public String[] getLabs() {
        return labs;
    }

    public void setLabs(String[] labs) {
        this.labs = labs;
    }

    public String getPoruka() {
        return poruka;
    }

    public void unesi() {

        Reservation r = new Reservation();
        r.setFrom(from);
        r.setLabs(labs);
        r.setTitle(title);
        r.setTo(to);

        ReservationDAO reservationDAO = new ReservationDAO();

        // rucna provera
        for (Reservation res : reservationDAO.getAllReservations()) {
            if ((r.getFrom().after(res.getFrom()) && r.getFrom().before(res.getTo()))
                    || (r.getTo().after(res.getFrom()) && r.getTo().before(res.getTo()))) {
                for (String labReserved : res.getLabs()) {
                    for (String labWant : r.getLabs()) {
                        if (labReserved.equals(labWant)) {
                            poruka = "Zauzeto od strane " + res.toString();
                            return;
                        }
                    }
                }
            }
        }

        // sa datumima u sql upitu
        for (Reservation res : reservationDAO.getAllReservationsBetween(from, to)) {
            for (String labReserved : res.getLabs()) {
                for (String labWant : r.getLabs()) {
                    if (labReserved.equals(labWant)) {
                        poruka = "Zauzeto od strane " + res.toString();
                        return;
                    }
                }
            }
        }

        // ako je sve OK proslo, ubaci u bazu
        if (reservationDAO.insertReservation2(r)) {
            poruka = "Unos uspesan.";
            title = "";
            from = null;
            to = null;
            labs = null;
        } else {
            poruka = "Doslo je do greske prilikom unosa.";
        }

    }

}
