import express from 'express';
import cors from 'cors'
import bodyParser from 'body-parser'
import mongoose from 'mongoose'
import korisnik from './model/korisnik';
import proizvod from './model/proizvod';

const app = express();

app.use(cors())
app.use(bodyParser.json())

mongoose.connect("mongodb://localhost:27017/lab2_baza");

const conn = mongoose.connection;

conn.once('open',()=>{
    console.log('Uspesna konekcija');
});

const router = express.Router();

router.route('/prijavaNaSistem').post((req, res)=>{
    let kor_ime = req.body.kor_ime;
    let lozinka = req.body.lozinka;

    korisnik.findOne({"kor_ime":kor_ime, "lozinka": lozinka}, (err, korisnik)=>{
        if(err) console.log(err);
        else res.json(korisnik);
    })
});

router.route('/dohvatiKorisnikaPoKorisnickomImenu').post((req, res)=>{
    let kor_ime = req.body.kor_ime;

    korisnik.findOne({"kor_ime":kor_ime}, (err, korisnik)=>{
        if(err) console.log(err);
        else res.json(korisnik);
    })
});

router.route('/dohvatiSveProizvodeKojihImaNaStanju').get((req, res)=>{
    proizvod.find({"kolicina": {$gt: 0}}, (err, proizvodi)=>{
        if(err) console.log(err);
        else res.json(proizvodi);
    })
});

router.route('/kupiProizvod').post((req, res)=>{
    let nazivProizvoda = req.body.nazivProizvoda;
    let kor_ime = req.body.kor_ime;

    proizvod.collection.updateOne({"naziv":nazivProizvoda}, {$inc: {"kolicina": -1}});
    korisnik.findOne({"kor_ime":kor_ime, "proizvodi.naziv": nazivProizvoda}, (err, korisnikJeVecKupovaoProizvod)=>{
        if(err) console.log(err);
        else{
            if(korisnikJeVecKupovaoProizvod){
                korisnik.collection.updateOne({"kor_ime":kor_ime, "proizvodi.naziv": nazivProizvoda}, {$inc: {"proizvodi.$.kolicina": 1}});
                //proizvodi.$.kolicina pristupam prvom objektu u kupljenim proizvodima koji ispunjava uslov
            }
            else{
                let kupljenProizvod={
                    naziv: nazivProizvoda,
                    kolicina: 1
                }
                korisnik.collection.updateOne({"kor_ime":kor_ime}, {$push: {"proizvodi": kupljenProizvod}});
            }
            res.json({poruka: 1});
        }
    })
});

router.route('/komentarisiProizvod').post((req, res)=>{
    let nazivProizvoda = req.body.nazivProizvoda;
    let komentar = req.body.komentar;

    let komentarObjekat = {
        komentar: komentar
    }

    proizvod.collection.updateOne({"naziv":nazivProizvoda}, {$push: {"komentari": komentarObjekat}});
    res.json({poruka: 1});
});

router.route('/dohvatiSveProizvode').get((req, res)=>{
    proizvod.find({}, (err, proizvodi)=>{
        if(err) console.log(err);
        else res.json(proizvodi);
    })
});

router.route('/dodajProizvod').post((req, res)=>{
    let nazivProizvoda = req.body.nazivProizvoda;

    proizvod.collection.updateOne({"naziv":nazivProizvoda}, {$inc: {"kolicina": 1}});
    res.json({poruka: 1});
});

router.route('/ukloniProizvod').post((req, res)=>{
    let nazivProizvoda = req.body.nazivProizvoda;

    proizvod.collection.updateOne({"naziv":nazivProizvoda}, {$inc: {"kolicina": -1}});
    res.json({poruka: 1});
});

app.use('/', router);
app.listen(4000, () => console.log(`Express server running on port 4000`));