import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { KorisnikService } from '../korisnik.service';
import { Korisnik } from '../model/korisnik.model';

@Component({
  selector: 'app-prijava',
  templateUrl: './prijava.component.html',
  styleUrls: ['./prijava.component.css']
})
export class PrijavaComponent implements OnInit {

  constructor(private servisKorisnik: KorisnikService, private ruter: Router) { }

  ngOnInit(): void {
  }

  kor_ime: string;
  lozinka: string;
  poruka: string;

  prijavaNaSistem(){
    this.servisKorisnik.prijavaNaSistem(this.kor_ime, this.lozinka).subscribe((korisnik: Korisnik)=>{
      if(!korisnik){
        this.poruka = 'Losi podaci';
      }
      else{
        localStorage.setItem('prijavljen', JSON.stringify(korisnik));
        if(korisnik.tip=="S"){
          this.ruter.navigate(['korisnik']);
        }
        else{
          this.ruter.navigate(['admin']);
        }
      }
    })
  }

}
