import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { KorisnikService } from '../korisnik.service';
import { Korisnik } from '../model/korisnik.model';
import { Proizvod } from '../model/proizvod.model';
import { ProizvodService } from '../proizvod.service';

@Component({
  selector: 'app-korisnik',
  templateUrl: './korisnik.component.html',
  styleUrls: ['./korisnik.component.css']
})
export class KorisnikComponent implements OnInit {

  constructor(private servisProizvod: ProizvodService, private ruter: Router, private servisKorisnik: KorisnikService) { }

  ngOnInit(): void {
    this.korisnik = JSON.parse(localStorage.getItem('prijavljen'))
    if(this.korisnik.tip!="S"){
      this.ruter.navigate(['prijava']);
    }
    this.servisProizvod.dohvatiSveProizvodeKojihImaNaStanju().subscribe((proizvodi: Proizvod[])=>{
      this.proizvodi = proizvodi;
    });
    
  }

  proizvodi: Proizvod[];
  poruka: string;
  korisnik: Korisnik;

  kupiProizvode(){
    this.proizvodi.forEach((proizvod)=>{
      if(proizvod.zaKupovinu){
        this.servisProizvod.kupiProizvod(proizvod.naziv, this.korisnik.kor_ime).subscribe((odg)=>{
          if(odg['poruka']==-1){
            this.poruka = 'Desila se greska';
          }
          else{
            this.servisKorisnik.dohvatiKorisnikaPoKorisnickomImenu(this.korisnik.kor_ime).subscribe((korisnik: Korisnik)=>{
              this.korisnik = korisnik;
            })
          }
        })
      }
    })
  }

  kupljenProizvod: string;
  komentar: string;

  komentarisi(){
    this.servisProizvod.komentarisiProizvod(this.kupljenProizvod, this.komentar).subscribe((odg)=>{
      if(odg['poruka']==-1){
        this.poruka = 'Desila se greska';
      }
    })
  }

}
