import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { Korisnik } from '../model/korisnik.model';
import { Proizvod } from '../model/proizvod.model';
import { ProizvodService } from '../proizvod.service';

@Component({
  selector: 'app-admin',
  templateUrl: './admin.component.html',
  styleUrls: ['./admin.component.css']
})
export class AdminComponent implements OnInit {

  constructor(private servisProizvod: ProizvodService, private ruter: Router) { }

  ngOnInit(): void {
    this.korisnik = JSON.parse(localStorage.getItem('prijavljen'));
    if(this.korisnik.tip!="A"){
      this.ruter.navigate(['prijava']);
    }
    this.servisProizvod.dohvatiSveProizvode().subscribe((proizvodi: Proizvod[])=>{
      this.proizvodi = proizvodi;
    })
  }

  korisnik: Korisnik;
  proizvodi: Proizvod[]
  poruka: string;

  dodajProizvod(proizvod){
    this.servisProizvod.dodajProizvod(proizvod.naziv).subscribe((odg)=>{
      if(odg['poruka']==-1){
        this.poruka = 'Desila se greska';
      }
      else{
        this.servisProizvod.dohvatiSveProizvode().subscribe((proizvodi: Proizvod[])=>{
          this.proizvodi = proizvodi;
        })
      }
    })
    
  }

  ukloniProizvod(proizvod){
    this.servisProizvod.ukloniProizvod(proizvod.naziv).subscribe((odg)=>{
      if(odg['poruka']==-1){
        this.poruka = 'Desila se greska';
      }
      else{
        this.servisProizvod.dohvatiSveProizvode().subscribe((proizvodi: Proizvod[])=>{
          this.proizvodi = proizvodi;
        })
      }
    })
  }

}
