package util.dao;

import entities.Radionica;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import util.DB;
import util.DateUtil;

public class RadionicaDAO implements DAOInterface<Radionica> {

    @Override
    public List<Radionica> getAll() {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** GRESKA u konekciji ka bazi");
            return null;
        }
        List<Radionica> res = new ArrayList<>();
        try ( PreparedStatement ps = con.prepareStatement("select * from radionice");  ResultSet rs = ps.executeQuery();) {
            while (rs.next()) {
                Radionica r = new Radionica();
                r.setIdR(rs.getInt("idR"));
                r.setNaziv(rs.getString("naziv"));
                r.setDatum(DateUtil.sqlDateToLocalDate(rs.getDate("datum")));
                r.setMesto(rs.getString("mesto"));
                r.setTehnika(rs.getString("tehnika"));
                r.setSlobodna_mesta(rs.getInt("slobodna_mesta"));
                if (r.getDatum().isBefore(DateUtil.currentLocalDate())) {
                    r.setIstekla(true);
                } else {
                    r.setIstekla(false);
                }
                res.add(r);
            }

        } catch (SQLException ex) {
            Logger.getLogger(KorisnikDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            DB.getInstance().putConnection(con);
        }
        return res;
    }

    @Override
    public Radionica getSpecific(String id) {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** GRESKA u konekciji ka bazi");
            return null;
        }

        try ( PreparedStatement ps = con.prepareStatement("select * from radionice where idR=?")) {
            ps.setString(1, id);

            try ( ResultSet rs = ps.executeQuery()) {
                if (rs.next()) {
                    Radionica r = new Radionica();
                    r.setIdR(rs.getInt("idR"));
                    r.setNaziv(rs.getString("naziv"));
                    r.setDatum(DateUtil.sqlDateToLocalDate(rs.getDate("datum")));
                    r.setMesto(rs.getString("mesto"));
                    r.setTehnika(rs.getString("tehnika"));
                    r.setSlobodna_mesta(rs.getInt("slobodna_mesta"));
                    if (r.getDatum().isBefore(DateUtil.currentLocalDate())) {
                        r.setIstekla(true);
                    } else {
                        r.setIstekla(false);
                    }
                    return r;
                }
            }
        } catch (SQLException ex) {
            Logger.getLogger(KorisnikDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            DB.getInstance().putConnection(con);
        }
        return null;
    }

    @Override
    public int insert(Radionica item) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int edit(Radionica item) {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** GRESKA u konekciji ka bazi");
            return -1;
        }

        try ( PreparedStatement ps = con.prepareStatement("update radionice set slobodna_mesta=? where idR=?");) {
            ps.setInt(1, item.getSlobodna_mesta());
            ps.setInt(2, item.getIdR());

            return ps.executeUpdate();

        } catch (SQLException ex) {
            Logger.getLogger(KorisnikDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            DB.getInstance().putConnection(con);
        }
        return -1;
    }

    @Override
    public int delete(Radionica item) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

}
