package util.dao;

import entities.Prijava;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import util.DB;

public class PrijavaDAO implements DAOInterface<Prijava> {

    @Override
    public List<Prijava> getAll() {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** GRESKA u konekciji ka bazi");
            return null;
        }
        List<Prijava> res = new ArrayList<>();
        try ( PreparedStatement ps = con.prepareStatement("select * from prijave");  ResultSet rs = ps.executeQuery();) {
            while (rs.next()) {
                Prijava p = new Prijava();
                p.setIdP(rs.getInt("idP"));
                p.setRadionica(new RadionicaDAO().getSpecific(String.valueOf(rs.getInt("radionica"))));
                p.setUcesnik(new KorisnikDAO().getSpecific(rs.getString("ucesnik")));
                p.setPosluzenje(rs.getInt("posluzenje"));
                p.setNapomena(rs.getString("napomena"));
                res.add(p);
            }

        } catch (SQLException ex) {
            Logger.getLogger(KorisnikDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            DB.getInstance().putConnection(con);
        }
        return res;
    }

    @Override
    public Prijava getSpecific(String id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int insert(Prijava item) {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** GRESKA u konekciji ka bazi");
            return -1;
        }

        try ( PreparedStatement ps = con.prepareStatement("insert into prijave (radionica, ucesnik, posluzenje, napomena) values(?,?,?,?)");) {
            ps.setInt(1, item.getRadionica().getIdR());
            ps.setString(2, item.getUcesnik().getKorisnicko_ime());
            ps.setInt(3, item.getPosluzenje());
            ps.setString(4, item.getNapomena());

            return ps.executeUpdate();

        } catch (SQLException ex) {
            Logger.getLogger(KorisnikDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            DB.getInstance().putConnection(con);
        }
        return -1;
    }

    @Override
    public int edit(Prijava item) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int delete(Prijava item) {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** GRESKA u konekciji ka bazi");
            return -1;
        }

        try ( PreparedStatement ps = con.prepareStatement("delete from prijave where idP=?");) {
            ps.setInt(1, item.getIdP());

            return ps.executeUpdate();

        } catch (SQLException ex) {
            Logger.getLogger(KorisnikDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            DB.getInstance().putConnection(con);
        }
        return -1;
    }

}
