package util.dao;

import entities.Korisnik;
import java.sql.*;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import util.DB;

public class KorisnikDAO implements DAOInterface<Korisnik> {

    @Override
    public List<Korisnik> getAll() {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** GRESKA u konekciji ka bazi");
            return null;
        }
        List<Korisnik> res = new ArrayList<>();
        try ( Statement st = con.createStatement();  ResultSet rs = st.executeQuery("select * from korisnici")) {

            while (rs.next()) {
                Korisnik k = new Korisnik();
                k.setKorisnicko_ime(rs.getString("korisnicko_ime"));
                k.setLozinka(rs.getString("lozinka"));
                k.setIme(rs.getString("ime"));
                k.setPrezime(rs.getString("prezime"));
                k.setTip(rs.getInt("tip"));
                k.setMejl(rs.getString("mejl"));
                res.add(k);
            }

        } catch (SQLException ex) {
            Logger.getLogger(KorisnikDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            DB.getInstance().putConnection(con);
        }
        return res;
    }

    @Override
    public Korisnik getSpecific(String id) {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** GRESKA u konekciji ka bazi");
            return null;
        }

        try ( PreparedStatement ps = con.prepareStatement("select * from korisnici where korisnicko_ime=?")) {

            ps.setString(1, id);

            try ( ResultSet rs = ps.executeQuery()) {
                if (rs.next()) {
                    Korisnik k = new Korisnik();
                    k.setKorisnicko_ime(rs.getString("korisnicko_ime"));
                    k.setLozinka(rs.getString("lozinka"));
                    k.setIme(rs.getString("ime"));
                    k.setPrezime(rs.getString("prezime"));
                    k.setTip(rs.getInt("tip"));
                    k.setMejl(rs.getString("mejl"));
                    return k;
                }
            }
        } catch (SQLException ex) {
            Logger.getLogger(KorisnikDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            DB.getInstance().putConnection(con);
        }
        return null;
    }

    @Override
    public int insert(Korisnik item) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int edit(Korisnik item) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int delete(Korisnik item) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

}
