package util.dao;

import java.util.List;

/**
 * Nije neophodno da postoji genericki interfejs.<br>
 * Moze se napraviti i interfejs za svaki DAO sa potrebnim metodama.
 *
 * @author Sanja
 * @param <T> tip/model klase za koji je ovaj DAO
 */
public interface DAOInterface<T> {

    public List<T> getAll();

    public T getSpecific(String id);

    public int insert(T item);

    public int edit(T item);

    public int delete(T item);
}
