package managed_beans;

import entities.Korisnik;
import entities.Prijava;
import entities.Radionica;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Named;
import java.util.List;
import util.SessionUtils;
import util.dao.PrijavaDAO;
import util.dao.RadionicaDAO;

@Named(value = "u")
@RequestScoped
public class UcesnikManagedBean {

    public UcesnikManagedBean() {
    }

    private List<Radionica> radionice;
    private final Korisnik ulogovan = (Korisnik) SessionUtils.getAttribute("korisnik");

    public List<Radionica> getRadionice() {
        return radionice;
    }

    public void setRadionice(List<Radionica> radionice) {
        this.radionice = radionice;
    }

    @PostConstruct
    public void init() {
        radionice = new RadionicaDAO().getAll();
    }

    public String prijava(Radionica r) {
        SessionUtils.setAttribute("radionica", r);
        return "prijava.xhtml?faces-redirect=true";
    }

    private boolean posl;
    private String napomena;

    public boolean isPosl() {
        return posl;
    }

    public void setPosl(boolean posl) {
        this.posl = posl;
    }

    public String getNapomena() {
        return napomena;
    }

    public void setNapomena(String napomena) {
        this.napomena = napomena;
    }

    private String message;

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String potvrdi() {
        Prijava p = new Prijava();
        if (posl) {
            p.setPosluzenje(1);
        } else {
            p.setPosluzenje(0);
        }
        p.setUcesnik(ulogovan);
        Radionica r = (Radionica) SessionUtils.getAttribute("radionica");
        p.setRadionica(r);
        p.setNapomena(napomena);
        if (new PrijavaDAO().insert(p) <= 0) {
            message = "Greska!";
            return "";
        }

        return "ucesnik.xhtml?faces-redirect=true";
    }
}
