package managed_beans;

import entities.Korisnik;
import entities.Prijava;
import entities.Radionica;
import jakarta.annotation.PostConstruct;
import jakarta.faces.view.ViewScoped;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.List;
import util.SessionUtils;
import util.dao.PrijavaDAO;
import util.dao.RadionicaDAO;

@Named(value = "s")
@ViewScoped
public class SlikarManagedBean implements Serializable {

    public SlikarManagedBean() {
    }

    private List<Prijava> prijave;
    private final Korisnik ulogovan = (Korisnik) SessionUtils.getAttribute("korisnik");

    public List<Prijava> getPrijave() {
        return prijave;
    }

    public void setPrijave(List<Prijava> prijave) {
        this.prijave = prijave;
    }

    @PostConstruct
    public void init() {
        prijave = new PrijavaDAO().getAll();
    }
    private String message;

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String prihvati(Prijava p) {
        Radionica r = p.getRadionica();
        if (r.isIstekla()) {
            message = "Isteklo je vreme za prijavu za radionicu " + r.getNaziv() + "!";
            return "";
        }
        if (r.getSlobodna_mesta() == 0) {
            message = "Nema vise slobodnih mesta za radionicu " + r.getNaziv() + "!";
            return "";
        }
        r.setSlobodna_mesta(r.getSlobodna_mesta() - 1);
        if (new RadionicaDAO().edit(r) <= 0) {
            message = "Greska!";
            return "";
        }
        if (new PrijavaDAO().delete(p) <= 0) {
            message = "Greska!";
            return "";
        }

        return "slikar";
    }
}
