package managed_beans;

import entities.Korisnik;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Named;
import util.SessionUtils;
import util.dao.KorisnikDAO;

@Named(value = "login")
@RequestScoped
public class LoginManagedBean {

    public LoginManagedBean() {
    }

    private String korisnickoIme;
    private String lozinka;
    private int tip;
    private String greska = "";

    public String getKorisnickoIme() {
        return korisnickoIme;
    }

    public void setKorisnickoIme(String korisnickoIme) {
        this.korisnickoIme = korisnickoIme;
    }

    public String getLozinka() {
        return lozinka;
    }

    public void setLozinka(String lozinka) {
        this.lozinka = lozinka;
    }

    public String getGreska() {
        return greska;
    }

    public void setGreska(String greska) {
        this.greska = greska;
    }

    public int getTip() {
        return tip;
    }

    public void setTip(int tip) {
        this.tip = tip;
    }

    public String login() {
        KorisnikDAO kdao = new KorisnikDAO();
        Korisnik k = kdao.getSpecific(korisnickoIme);
        if (k != null) {
            if (k.getLozinka().equals(lozinka)) {
                SessionUtils.setAttribute("korisnik", k);
                if (k.getTip() == 0 && k.getTip() == tip) {
                    // ucesnik
                    return "ucesnik";
                } else if (k.getTip() == 0 && k.getTip() != tip) {
                    greska = "Nepostojeci korisnik.";
                    return "";
                } else if (k.getTip() == 1 && k.getTip() == tip) {
                    // slikar
                    return "slikar";
                } else {
                    greska = "Nepostojeci korisnik.";
                    return "";
                }

            } else {
                greska = "Pogresna lozinka.";
            }
        } else {
            greska = "Nepostojeci korisnik.";
        }
        return "";
    }

    public String logout() {
        SessionUtils.invalidate();
        return "index.html?faces-redirect=true";
    }
}
