import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { Ispit } from '../models/ispit';

@Injectable({
  providedIn: 'root'
})
export class IspitService {

  constructor() { }

  private http = inject(HttpClient)

  backendUrl = "http://localhost:8080"

  dohvatiProsekStudenta(indeks: string){
    return this.http.get<number>(`${this.backendUrl}/ispiti/prosekOcenaZaStudenta/${indeks}`);
  }

  dohvatiIspiteUIntervalu(datumOd: Date, datumDo: Date){
    const data = {
      datumOd: datumOd,
      datumDo: datumDo
    }
    return this.http.post<Ispit[]>(`${this.backendUrl}/ispiti/dohvatiIspiteUIntervalu`, data);
  }

  dodavanjeIspitaZaStudenta(i: Ispit){
    return this.http.post<Ispit[]>(`${this.backendUrl}/ispiti/dodavanjeIspitaZaStudenta`, i);
  }
}
