import { Component, inject, OnInit } from '@angular/core';
import { StudentService } from '../services/student.service';
import { IspitService } from '../services/ispit.service';
import { Router } from '@angular/router';
import { Ispit } from '../models/ispit';

@Component({
  selector: 'app-komponenta3',
  imports: [],
  templateUrl: './komponenta3.html',
  styleUrl: './komponenta3.css',
})
export class Komponenta3 implements OnInit {
  private studentServis = inject(StudentService)
  private ispitServis = inject(IspitService)
  private router = inject(Router)

  ngOnInit(): void {
    this.ispisiTabelu = false;
    let ispitStr = localStorage.getItem("ispit");
    if(ispitStr!=null){
      this.poslednjiIspit = JSON.parse(ispitStr);
      this.poslednjiIspit.datum = new Date();

      this.studentServis.dohvatiStudentaPoIndeksu(this.poslednjiIspit.student.substring(0,4)+this.poslednjiIspit.student.substring(5,9)).subscribe(
        podaci=>{
          if(podaci!=null){
            this.ispisiTabelu = true;
            this.ispitServis.dodavanjeIspitaZaStudenta(this.poslednjiIspit).subscribe(
              podaci=>{
                this.ispitiZaStudenta = podaci;
              }
            )
          }
        }
      )
    }
  }

  poslednjiIspit: Ispit = new Ispit()
  ispisiTabelu: boolean = false;
  ispitiZaStudenta: Ispit[] = []

  nazad(){
    this.router.navigate(['']);
  }

}
