import { Component, inject, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { StudentService } from '../services/student.service';
import { IspitService } from '../services/ispit.service';
import { Student } from '../models/student';

@Component({
  selector: 'app-komponenta1',
  imports: [],
  templateUrl: './komponenta1.html',
  styleUrl: './komponenta1.css',
})
export class Komponenta1 implements OnInit {
  private route = inject(ActivatedRoute)
  private router = inject(Router)
  private studentServis = inject(StudentService)
  private ispitiServis = inject(IspitService)

  ngOnInit(): void {
    this.ispisatiPodatke = false;
    let indeksParam = this.route.snapshot.paramMap.get("indeksParam");
    
    if(indeksParam!=null){
      this.studentServis.dohvatiStudentaPoIndeksu(indeksParam).subscribe(
        podaci=>{
          if(podaci==null){
            this.porukaGreske = "Student ne postoji"
          }
          else{
            this.student = podaci;
            if(indeksParam!=null){
              this.ispitiServis.dohvatiProsekStudenta(indeksParam).subscribe(
                podaci=>{
                  if(podaci==0){
                    this.porukaGreske = "Nema ispita za tog studenta"
                  }
                  else{
                    this.prosek = podaci;
                    this.ispisatiPodatke = true;
                  }                 
                }
              ) 
            } 
          }          
        }
      )      
    }
  }

  student: Student = new Student();
  prosek: number = 0;

  ispisatiPodatke: boolean = false;
  porukaGreske: string = "";

  nazad(){
    this.router.navigate(['']);
  }
}
