package com.example.backend.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.example.backend.models.Student;

public class StudentRepo implements StudentRepoInterface {

    @Override
    public Student dohvatiStudentaPoIndeksu(String indeks) {
        try (Connection conn = DB.source().getConnection();
        PreparedStatement stm = conn.prepareStatement("select * from studenti where indeks = ?");) {
            stm.setString(1, indeks);
            ResultSet rs = stm.executeQuery();
            if(rs.next()){
                Student student = new Student(
                    rs.getString("ime"), 
                    rs.getString("prezime"), 
                    rs.getInt("godina"), 
                    rs.getString("indeks"));
                return student;
            }
        } catch (SQLException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }
    
}
