package com.example.backend.controllers;

import java.util.List;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.backend.db.IspitRepo;
import com.example.backend.models.Ispit;
import com.example.backend.models.helpers.DatumiPretraga;

@RestController
@RequestMapping("/ispiti")
@CrossOrigin(origins = "http://localhost:4200/")
public class IspitController {

    @GetMapping("/prosekOcenaZaStudenta/{indeks}")
    public double dohvatiProsekOcenaZaStudenta(@PathVariable String indeks){
        String ceoIndeks = indeks.substring(0, 4) + "/" + indeks.substring(4, 8);
        return new IspitRepo().dohvatiProsekOcenaZaStudenta(ceoIndeks);
    }

    @PostMapping("/dohvatiIspiteUIntervalu")
    public List<Ispit> dohvatiIspiteUIntervalu(@RequestBody DatumiPretraga datumi){
        return new IspitRepo().dohvatiIspiteUIntervalu(datumi.getDatumOd(), datumi.getDatumDo());
    }

    @PostMapping("/dodavanjeIspitaZaStudenta")
    public List<Ispit> dodavanjeIspitaZaStudenta(@RequestBody Ispit i){
        return new IspitRepo().dodavanjeIspitaZaStudenta(i);
    }
    
}
