import { Component, inject } from '@angular/core';
import { Router } from '@angular/router';
import { Ispit } from '../models/ispit';
import { FormsModule } from '@angular/forms'

@Component({
  selector: 'app-pocetna',
  standalone: true,
  imports: [FormsModule],
  templateUrl: './pocetna.component.html',
  styleUrl: './pocetna.component.css'
})
export class PocetnaComponent {

  private router = inject(Router)

  //Prva forma
  prvaFormaIndeks: string = "";
  porukaPrvaForma: string = "";
  forma1(){
    if(this.prvaFormaIndeks==""){
      this.porukaPrvaForma = "Niste uneli indeks";
    }
    else{
      let regex = /^\d{4}\/\d{4}$/
      if(regex.test(this.prvaFormaIndeks)){
        let indeks = this.prvaFormaIndeks.split("/");
        this.router.navigate(['k1', {indeksParam: indeks[0]+indeks[1]}]);
      }
      else{
        this.porukaPrvaForma = "Indeks je u losem formatu";
      }
      
    }   
  }

  //Druga forma
  drugaFormaDatumOdStr: string = "";
  drugaFormaDatumDoStr: string = "";
  porukaDrugaForma: string = "";
  forma2(){    
    let drugaFormaDatumOd = new Date(this.drugaFormaDatumOdStr);
    let drugaFormaDatumDo = new Date(this.drugaFormaDatumDoStr);
    if(drugaFormaDatumOd>drugaFormaDatumDo || drugaFormaDatumDo<drugaFormaDatumOd){
      this.porukaDrugaForma = "Datumi nisu u dobrom poretku";
    }
    else{
      localStorage.setItem("drugaFormaDatumOd", this.drugaFormaDatumOdStr);
      localStorage.setItem("drugaFormaDatumDo", this.drugaFormaDatumDoStr);
      this.router.navigate(['k2']);
    }
  }

  //Treca forma
  ispit: Ispit = new Ispit();
  porukaTrecaForma: string = "";
  forma3(){
    let regex = /^\d{4}\/\d{4}$/
    if(this.ispit.sifra=="" || this.ispit.student=="" || !regex.test(this.ispit.student) || this.ispit.ocena<5 || this.ispit.ocena>10){
      this.porukaTrecaForma = "Niste uneli dobre podatke";
    }
    else{
      localStorage.setItem("ispit", JSON.stringify(this.ispit));
      this.router.navigate(["k3"]);
    }
  }

}
