import { Component, inject, OnInit } from '@angular/core';
import { IspitService } from '../services/ispit.service';
import { Ispit } from '../models/ispit';
import { Router } from '@angular/router';

@Component({
  selector: 'app-komponenta2',
  standalone: true,
  imports: [],
  templateUrl: './komponenta2.component.html',
  styleUrl: './komponenta2.component.css'
})
export class Komponenta2Component implements OnInit {

  private ispitiServis = inject(IspitService)
  private router = inject(Router)

  ngOnInit(): void {
    let datumOdStr = localStorage.getItem("drugaFormaDatumOd");
    let datumDoStr = localStorage.getItem("drugaFormaDatumDo");
    if(datumOdStr!=null && datumDoStr!=null){
      this.ispitiServis.dohvatiIspiteUIntervalu(new Date(datumOdStr), new Date(datumDoStr)).subscribe(
        podaci=>{
          if(podaci.length!=0 && podaci!=null){
            this.ispiti = podaci;
            this.ispisiTabelu = true;
          }
          else{
            this.ispisiTabelu = false;
          }
          
        }
      )
    }
  }

  ispiti: Ispit[] = []
  ispisiTabelu: boolean = false;

  nazad(){
    this.router.navigate(['']);
  }
}
