package com.example.demo.controllers;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.db.StudentRepo;
import com.example.demo.models.Student;

@RestController
@RequestMapping("/student")
@CrossOrigin(origins = "http://localhost:4200/")
public class StudentController {
    
    @GetMapping("/dohvatiStudenta/{indeks}")
    public Student dohvatiStudenta(@PathVariable String indeks){
        String ceoIndeks = indeks.substring(0, 4) + "/" + indeks.substring(4, 8);
        return new StudentRepo().dohvatiStudentaPoIndeksu(ceoIndeks);
    }
}
