package managed_beans;

import entities.Diplomski;
import entities.Korisnik;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Named;
import java.util.List;
import util.SessionUtils;
import util.dao.DiplomskiDAO;
import util.dao.KorisnikDAO;

@Named(value = "dipl")
@RequestScoped
public class DiplomskiManagedBean {

    public DiplomskiManagedBean() {
    }

    private Diplomski d = null;
    private Diplomski novi = new Diplomski();

    Korisnik ulogovan = (Korisnik) SessionUtils.getAttribute("korisnik");
    private String greska = "";
    private Korisnik mentor = null;
    private List<Korisnik> nastavnici;

    DiplomskiDAO dAO = new DiplomskiDAO();

    public Diplomski getD() {
        return d;
    }

    public void setD(Diplomski d) {
        this.d = d;
    }

    public Diplomski getNovi() {
        return novi;
    }

    public void setNovi(Diplomski novi) {
        this.novi = novi;
    }

    public String getGreska() {
        return greska;
    }

    public void setGreska(String greska) {
        this.greska = greska;
    }

    public Korisnik getMentor() {
        return mentor;
    }

    public void setMentor(Korisnik mentor) {
        this.mentor = mentor;
    }

    public List<Korisnik> getNastavnici() {
        return nastavnici;
    }

    public void setNastavnici(List<Korisnik> nastavnici) {
        this.nastavnici = nastavnici;
    }

    @PostConstruct
    public void inicijalizacija() {
        KorisnikDAO kdao = new KorisnikDAO();

        d = dAO.getSpecific(ulogovan.getKorisnicko_ime());
        // Mogli smo i u diplomskom da stavimo da mentor bude tipa Korisnik,
        // pa prilikom dohvatanja da opet u ugnjezdjenom upitu dohvatimo
        // podatke o mentoru, a mozemo i ovako:
        // ako ima prijave diplomskog, dohvati i mentora
        if (d != null) {
            mentor = kdao.getSpecific(d.getMentor());
        } else {
            nastavnici = kdao.getAllTeachers();
        }
    }

    public String prijava() {
        novi.setStudent(ulogovan);
        novi.setOcena(null);
		
	if(ulogovan.getEspb()<230){
            greska = "Nemate dovoljno ESPB";
            return null;
        }

        int res = dAO.insert(novi);
        if (res == 0) {
            greska = "Doslo je do greske prilikom unosa";
            return null;
        } else {
            greska = "Uspesan unos";
            return "student.xhtml?faces-redirect=true";
        }

    }
}
