package util.dao;

import entities.Diplomski;
import entities.Korisnik;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import util.DB;

public class DiplomskiDAO implements DAOInterface<Diplomski> {

    @Override
    public List<Diplomski> getAll() {
        throw new UnsupportedOperationException("Not supported yet."); // Generated from nbfs://nbhost/SystemFileSystem/Templates/Classes/Code/GeneratedMethodBody
    }

    public List<Diplomski> getAllForTeacher(String username) {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** GRESKA u konekciji ka bazi");
            return null;
        }

        try ( PreparedStatement ps = con.prepareStatement("select * from diplomski as d, korisnici as k where mentor=? and d.student=k.korisnicko_ime")) {

            ps.setString(1, username);
            List<Diplomski> res = new ArrayList<>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Diplomski d = new Diplomski();
                Korisnik student = new Korisnik();
                student.setKorisnicko_ime(rs.getString("d.student"));
                student.setIme(rs.getString("ime"));
                student.setPrezime(rs.getString("prezime"));
                d.setStudent(student);
                d.setNaslov(rs.getString("naslov"));
                d.setOpis(rs.getString("opis"));
                d.setMentor(rs.getString("mentor"));
                d.setOcena((Integer) rs.getObject("ocena"));

                res.add(d);
            }
            rs.close();
            return res;
        } catch (SQLException ex) {
            Logger.getLogger(DiplomskiDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            DB.getInstance().putConnection(con);
        }
        return null;
    }

    @Override
    public Diplomski getSpecific(String id) {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** GRESKA u konekciji ka bazi");
            return null;
        }

        try ( PreparedStatement ps = con.prepareStatement("select * from diplomski where student=?")) {

            ps.setString(1, id);

            try ( ResultSet rs = ps.executeQuery()) {
                if (rs.next()) {
                    Diplomski d = new Diplomski();

                    d.setStudent(new Korisnik(rs.getString("student")));
                    d.setNaslov(rs.getString("naslov"));
                    d.setOpis(rs.getString("opis"));
                    d.setMentor(rs.getString("mentor"));
                    d.setOcena((Integer) rs.getObject("ocena"));

                    return d;
                }
            }
        } catch (SQLException ex) {
            Logger.getLogger(DiplomskiDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            DB.getInstance().putConnection(con);
        }
        return null;
    }

    @Override
    public int insert(Diplomski item) {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** GRESKA u konekciji ka bazi");
            return 0;
        }

        try ( PreparedStatement ps = con.prepareStatement("insert into diplomski values(?,?,?,?,?)")) {

            ps.setString(1, item.getStudent().getKorisnicko_ime());
            ps.setString(2, item.getNaslov());
            ps.setString(3, item.getOpis());
            ps.setString(4, item.getMentor());
            ps.setObject(5, null);

            return ps.executeUpdate();
        } catch (SQLException ex) {
            Logger.getLogger(DiplomskiDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            DB.getInstance().putConnection(con);
        }
        return 0;
    }

    @Override
    public int edit(Diplomski item) {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** GRESKA u konekciji ka bazi");
            return 0;
        }

        try ( PreparedStatement ps = con.prepareStatement("update diplomski set ocena=? where student=?")) {

            ps.setInt(1, item.getOcena());
            ps.setString(2, item.getStudent().getKorisnicko_ime());

            return ps.executeUpdate();
        } catch (SQLException ex) {
            Logger.getLogger(DiplomskiDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            DB.getInstance().putConnection(con);
        }
        return 0;
    }

    @Override
    public int delete(Diplomski item) {
        Connection con = DB.getInstance().getConnection();
        if (con == null) {
            System.err.println("*** GRESKA u konekciji ka bazi");
            return 0;
        }

        try ( PreparedStatement ps = con.prepareStatement("delete from diplomski where student=?")) {

            ps.setString(1, item.getStudent().getKorisnicko_ime());

            return ps.executeUpdate();
        } catch (SQLException ex) {
            Logger.getLogger(DiplomskiDAO.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            DB.getInstance().putConnection(con);
        }
        return 0;
    }

}
